/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class NumberConverter {
    private static final int[] DIGITS = new int[1000];
    private static final double[] POW_10 = new double[18];
    static final JsonReader.ReadObject<Double> DoubleReader = new JsonReader.ReadObject<Double>(){

        @Override
        public Double read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeDouble(reader);
        }
    };
    static final JsonWriter.WriteObject<Double> DoubleWriter = new JsonWriter.WriteObject<Double>(){

        @Override
        public void write(JsonWriter writer, Double value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Float> FloatReader = new JsonReader.ReadObject<Float>(){

        @Override
        public Float read(JsonReader reader) throws IOException {
            return Float.valueOf(NumberConverter.deserializeFloat(reader));
        }
    };
    static final JsonWriter.WriteObject<Float> FloatWriter = new JsonWriter.WriteObject<Float>(){

        @Override
        public void write(JsonWriter writer, Float value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Integer> IntReader = new JsonReader.ReadObject<Integer>(){

        @Override
        public Integer read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeInt(reader);
        }
    };
    static final JsonWriter.WriteObject<Integer> IntWriter = new JsonWriter.WriteObject<Integer>(){

        @Override
        public void write(JsonWriter writer, Integer value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Long> LongReader = new JsonReader.ReadObject<Long>(){

        @Override
        public Long read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeLong(reader);
        }
    };
    static final JsonWriter.WriteObject<Long> LongWriter = new JsonWriter.WriteObject<Long>(){

        @Override
        public void write(JsonWriter writer, Long value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<BigDecimal> DecimalReader = new JsonReader.ReadObject<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeDecimal(reader);
        }
    };
    static final JsonWriter.WriteObject<BigDecimal> DecimalWriter = new JsonWriter.WriteObject<BigDecimal>(){

        @Override
        public void write(JsonWriter writer, BigDecimal value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Number> NumberReader = new JsonReader.ReadObject<Number>(){

        @Override
        public Number read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeNumber(reader);
        }
    };
    private static final byte MINUS = 45;
    private static final byte[] MIN_INT;
    private static final byte[] MIN_LONG;

    static void write4(int value, byte[] buf, int pos) {
        if (value > 9999) {
            throw new IllegalArgumentException("Only 4 digits numbers are supported. Provided: " + value);
        }
        int q = value / 1000;
        int v = DIGITS[value - q * 1000];
        buf[pos] = (byte)(q + 48);
        buf[pos + 1] = (byte)(v >> 16);
        buf[pos + 2] = (byte)(v >> 8);
        buf[pos + 3] = (byte)v;
    }

    static void write3(int number, byte[] buf, int pos) {
        int v = DIGITS[number];
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    static void write2(int value, byte[] buf, int pos) {
        int v = DIGITS[value];
        buf[pos] = (byte)(v >> 8);
        buf[pos + 1] = (byte)v;
    }

    static int read2(char[] buf, int pos) {
        int v1 = buf[pos] - 48;
        return (v1 << 3) + (v1 << 1) + buf[pos + 1] - 48;
    }

    static int read4(char[] buf, int pos) {
        int v2 = buf[pos + 1] - 48;
        int v3 = buf[pos + 2] - 48;
        return (buf[pos] - 48) * 1000 + (v2 << 6) + (v2 << 5) + (v2 << 2) + (v3 << 3) + (v3 << 1) + buf[pos + 3] - 48;
    }

    public static void serializeNullable(Double value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value, sw);
        }
    }

    private static BigDecimal parseNumberGeneric(char[] buf, int len, JsonReader reader) throws IOException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        try {
            return new BigDecimal(buf, 0, end);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing number at position: " + reader.positionInStream(len), nfe);
        }
    }

    public static void serialize(double value, JsonWriter sw) {
        if (Double.isNaN(value)) {
            sw.writeAscii("\"NaN\"");
        } else if (Double.isInfinite(value)) {
            long bits = Double.doubleToLongBits(value);
            if ((bits & Long.MIN_VALUE) != 0L) {
                sw.writeAscii("\"-Infinity\"");
            } else {
                sw.writeAscii("\"Infinity\"");
            }
        } else {
            sw.writeAscii(Double.toString(value));
        }
    }

    public static void serialize(double[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("[]");
        } else {
            sw.writeByte((byte)91);
            NumberConverter.serialize(value[0], sw);
            for (int i = 1; i < value.length; ++i) {
                sw.writeByte((byte)44);
                NumberConverter.serialize(value[i], sw);
            }
            sw.writeByte((byte)93);
        }
    }

    private static NumberInfo readLongNumber(JsonReader reader, int start) throws IOException {
        char[] tmp = reader.prepareBuffer(start);
        int i = tmp.length;
        tmp = Arrays.copyOf(tmp, tmp.length * 2);
        while (!reader.isEndOfStream()) {
            do {
                char ch = (char)reader.read();
                tmp[i++] = ch;
                if (!reader.isEndOfStream() && (ch >= '0' && ch < '9' || ch == '-' || ch == '+' || ch == '.' || ch == 'e' || ch == 'E')) continue;
                return new NumberInfo(tmp, reader.isEndOfStream() ? i : i - 1);
            } while (i < tmp.length);
            tmp = Arrays.copyOf(tmp, tmp.length * 2);
        }
        return new NumberInfo(tmp, i);
    }

    public static double deserializeDouble(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberConverter.parseDoubleGeneric(buf, reader.getCurrentIndex() - position - 1, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            if (len == reader.tmpLength) {
                NumberInfo tmp = NumberConverter.readLongNumber(reader, start);
                return NumberConverter.parseDoubleGeneric(tmp.buffer, tmp.length, reader);
            }
            return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start), len, reader);
        }
        byte[] buf = reader.buffer;
        byte ch = buf[0];
        if (ch == 45) {
            return NumberConverter.parseNegativeDouble(buf, reader, start, end, start + 1);
        }
        if (ch == 43) {
            return NumberConverter.parsePositiveDouble(buf, reader, start, end, start + 1);
        }
        return NumberConverter.parsePositiveDouble(buf, reader, start, end, start);
    }

    private static double parsePositiveDouble(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        long value = 0L;
        int ch = 32;
        while (i < end && (ch = buf[i]) != 46) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) + (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start), end - start, reader);
            }
            ++i;
        }
        if (i == end) {
            return value;
        }
        if (ch == 46) {
            ++i;
            long div = 1L;
            while (i < end) {
                int ind = buf[i] - 48;
                div = (div << 3) + (div << 1);
                value = (value << 3) + (value << 1) + (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            return (double)value / (double)div;
        }
        return value;
    }

    private static double parseNegativeDouble(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        long value = 0L;
        int ch = 32;
        while (i < end && (ch = buf[i]) != 46) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) - (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start), end - start, reader);
            }
            ++i;
        }
        if (i == end) {
            return value;
        }
        if (ch == 46) {
            ++i;
            long div = 1L;
            while (i < end) {
                int ind = buf[i] - 48;
                div = (div << 3) + (div << 1);
                value = (value << 3) + (value << 1) - (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            return (double)value / (double)div;
        }
        return value;
    }

    private static double parseDoubleGeneric(char[] buf, int len, JsonReader reader) throws IOException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        try {
            return Double.parseDouble(new String(buf, 0, end));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing float number at position: " + reader.positionInStream(len), nfe);
        }
    }

    public static ArrayList<Double> deserializeDoubleCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(DoubleReader);
    }

    public static void deserializeDoubleCollection(JsonReader reader, Collection<Double> res) throws IOException {
        reader.deserializeCollection(DoubleReader, res);
    }

    public static ArrayList<Double> deserializeDoubleNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(DoubleReader);
    }

    public static void deserializeDoubleNullableCollection(JsonReader reader, Collection<Double> res) throws IOException {
        reader.deserializeNullableCollection(DoubleReader, res);
    }

    public static void serializeNullable(Float value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value.floatValue(), sw);
        }
    }

    public static void serialize(float value, JsonWriter sw) {
        if (Float.isNaN(value)) {
            sw.writeAscii("\"NaN\"");
        } else if (Float.isInfinite(value)) {
            int bits = Float.floatToIntBits(value);
            if ((bits & Integer.MIN_VALUE) != 0) {
                sw.writeAscii("\"-Infinity\"");
            } else {
                sw.writeAscii("\"Infinity\"");
            }
        } else {
            sw.writeAscii(Float.toString(value));
        }
    }

    public static void serialize(float[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("[]");
        } else {
            sw.writeByte((byte)91);
            NumberConverter.serialize(value[0], sw);
            for (int i = 1; i < value.length; ++i) {
                sw.writeByte((byte)44);
                NumberConverter.serialize(value[i], sw);
            }
            sw.writeByte((byte)93);
        }
    }

    public static float deserializeFloat(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberConverter.parseFloatGeneric(buf, reader.getCurrentIndex() - position - 1, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            if (len == reader.tmpLength) {
                NumberInfo tmp = NumberConverter.readLongNumber(reader, start);
                return NumberConverter.parseFloatGeneric(tmp.buffer, tmp.length, reader);
            }
            return NumberConverter.parseFloatGeneric(reader.prepareBuffer(start), len, reader);
        }
        byte[] buf = reader.buffer;
        byte ch = buf[0];
        if (ch == 45) {
            return NumberConverter.parseNegativeFloat(buf, reader, start, end, start + 1);
        }
        if (ch == 43) {
            return NumberConverter.parsePositiveFloat(buf, reader, start, end, start + 1);
        }
        return NumberConverter.parsePositiveFloat(buf, reader, start, end, start);
    }

    private static float parsePositiveFloat(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        long value = 0L;
        int ch = 32;
        while (i < end && (ch = buf[i]) != 46) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) + (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseFloatGeneric(reader.prepareBuffer(start), end - start, reader);
            }
            ++i;
        }
        if (ch == 46) {
            ++i;
            int div = 1;
            while (i < end) {
                int ind = buf[i] - 48;
                div = (div << 3) + (div << 1);
                value = (value << 3) + (value << 1) + (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseFloatGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            return (float)value / (float)div;
        }
        return value;
    }

    private static float parseNegativeFloat(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        long value = 0L;
        int ch = 32;
        while (i < end && (ch = buf[i]) != 46) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) - (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseFloatGeneric(reader.prepareBuffer(start), end - start, reader);
            }
            ++i;
        }
        if (ch == 46) {
            ++i;
            int div = 1;
            while (i < end) {
                int ind = buf[i] - 48;
                div = (div << 3) + (div << 1);
                value = (value << 3) + (value << 1) - (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseFloatGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            return (float)value / (float)div;
        }
        return value;
    }

    private static float parseFloatGeneric(char[] buf, int len, JsonReader reader) throws IOException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        try {
            return Float.parseFloat(new String(buf, 0, end));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing float number at position: " + reader.positionInStream(len), nfe);
        }
    }

    public static ArrayList<Float> deserializeFloatCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(FloatReader);
    }

    public static void deserializeFloatCollection(JsonReader reader, Collection<Float> res) throws IOException {
        reader.deserializeCollection(FloatReader, res);
    }

    public static ArrayList<Float> deserializeFloatNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(FloatReader);
    }

    public static void deserializeFloatNullableCollection(JsonReader reader, Collection<Float> res) throws IOException {
        reader.deserializeNullableCollection(FloatReader, res);
    }

    public static void serializeNullable(Integer value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value, sw);
        }
    }

    public static void serialize(int value, JsonWriter sw) {
        byte[] buf = sw.ensureCapacity(11);
        int position = sw.size();
        int current = NumberConverter.serialize(buf, position, value);
        sw.advance(current - position);
    }

    private static int serialize(byte[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                for (int x = 0; x < MIN_INT.length; ++x) {
                    buf[pos + x] = MIN_INT[x];
                }
                return pos + MIN_INT.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        int q1 = i / 1000;
        if (q1 == 0) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[i], pos);
            return pos;
        }
        int r1 = i - q1 * 1000;
        int q2 = q1 / 1000;
        if (q2 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[q1];
            int off = NumberConverter.writeFirstBuf(buf, v2, pos);
            NumberConverter.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = q1 - q2 * 1000;
        long q3 = q2 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        if (q3 == 0L) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[q2], pos);
        } else {
            int r3 = (int)((long)q2 - q3 * 1000L);
            buf[pos++] = (byte)(q3 + 48L);
            NumberConverter.writeBuf(buf, DIGITS[r3], pos);
            pos += 3;
        }
        NumberConverter.writeBuf(buf, v2, pos);
        NumberConverter.writeBuf(buf, v1, pos + 3);
        return pos + 6;
    }

    public static void serialize(int[] values, JsonWriter sw) {
        if (values == null) {
            sw.writeNull();
        } else if (values.length == 0) {
            sw.writeAscii("[]");
        } else {
            byte[] buf = sw.ensureCapacity(values.length * 21 + 2);
            int position = sw.size();
            buf[position++] = 91;
            position = NumberConverter.serialize(buf, position, values[0]);
            for (int i = 1; i < values.length; ++i) {
                buf[position++] = 44;
                position = NumberConverter.serialize(buf, position, values[i]);
            }
            buf[position++] = 93;
            sw.advance(position - sw.size());
        }
    }

    public static void serialize(short[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("[]");
        } else {
            sw.writeByte((byte)91);
            NumberConverter.serialize(value[0], sw);
            for (int i = 1; i < value.length; ++i) {
                sw.writeByte((byte)44);
                NumberConverter.serialize(value[i], sw);
            }
            sw.writeByte((byte)93);
        }
    }

    public static int deserializeInt(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberConverter.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader).intValue();
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            return NumberConverter.parseNegativeInt(buf, reader, start, end, start + 1);
        }
        if (ch == 43) {
            return NumberConverter.parsePositiveInt(buf, reader, start, end, start + 1);
        }
        return NumberConverter.parsePositiveInt(buf, reader, start, end, start);
    }

    private static int parsePositiveInt(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        int value = 0;
        while (i < end) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) + ind;
            if (ind < 0 || ind > 9) {
                BigDecimal v = NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
                if (v.scale() <= 0) {
                    return v.intValue();
                }
                throw new IOException("Error parsing int number at position: " + reader.positionInStream(end - start) + ". Found decimal value: " + v);
            }
            ++i;
        }
        return value;
    }

    private static int parseNegativeInt(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        int value = 0;
        while (i < end) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) - ind;
            if (ind < 0 || ind > 9) {
                BigDecimal v = NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
                if (v.scale() <= 0) {
                    return v.intValue();
                }
                throw new IOException("Error parsing int number at position: " + reader.positionInStream(end - start) + ". Found decimal value: " + v);
            }
            ++i;
        }
        return value;
    }

    public static ArrayList<Integer> deserializeIntCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(IntReader);
    }

    public static void deserializeIntCollection(JsonReader reader, Collection<Integer> res) throws IOException {
        reader.deserializeCollection(IntReader, res);
    }

    public static ArrayList<Integer> deserializeIntNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(IntReader);
    }

    public static void deserializeIntNullableCollection(JsonReader reader, Collection<Integer> res) throws IOException {
        reader.deserializeNullableCollection(IntReader, res);
    }

    public static void serializeNullable(Long value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value, sw);
        }
    }

    private static int writeFirstBuf(byte[] buf, int v, int pos) {
        int start = v >> 24;
        if (start == 0) {
            buf[pos++] = (byte)(v >> 16);
            buf[pos++] = (byte)(v >> 8);
        } else if (start == 1) {
            buf[pos++] = (byte)(v >> 8);
        }
        buf[pos] = (byte)v;
        return 3 - start;
    }

    private static void writeBuf(byte[] buf, int v, int pos) {
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    public static void serialize(long value, JsonWriter sw) {
        byte[] buf = sw.ensureCapacity(21);
        int position = sw.size();
        int current = NumberConverter.serialize(buf, position, value);
        sw.advance(current - position);
    }

    private static int serialize(byte[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                for (int x = 0; x < MIN_LONG.length; ++x) {
                    buf[pos + x] = MIN_LONG[x];
                }
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        long q1 = i / 1000L;
        if (q1 == 0L) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[(int)i], pos);
            return pos;
        }
        int r1 = (int)(i - q1 * 1000L);
        long q2 = q1 / 1000L;
        if (q2 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[(int)q1];
            int off = NumberConverter.writeFirstBuf(buf, v2, pos);
            NumberConverter.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        if (q3 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[(int)q2];
            pos += NumberConverter.writeFirstBuf(buf, v3, pos);
            NumberConverter.writeBuf(buf, v2, pos);
            NumberConverter.writeBuf(buf, v1, pos + 3);
            return pos + 6;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        if (q4 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[(int)q3];
            pos += NumberConverter.writeFirstBuf(buf, v4, pos);
            NumberConverter.writeBuf(buf, v3, pos);
            NumberConverter.writeBuf(buf, v2, pos + 3);
            NumberConverter.writeBuf(buf, v1, pos + 6);
            return pos + 9;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        if (q5 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[r4];
            int v5 = DIGITS[q4];
            pos += NumberConverter.writeFirstBuf(buf, v5, pos);
            NumberConverter.writeBuf(buf, v4, pos);
            NumberConverter.writeBuf(buf, v3, pos + 3);
            NumberConverter.writeBuf(buf, v2, pos + 6);
            NumberConverter.writeBuf(buf, v1, pos + 9);
            return pos + 12;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        int v3 = DIGITS[r3];
        int v4 = DIGITS[r4];
        int v5 = DIGITS[r5];
        if (q6 == 0) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[q5], pos);
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos++] = (byte)(q6 + 48);
            NumberConverter.writeBuf(buf, DIGITS[r6], pos);
            pos += 3;
        }
        NumberConverter.writeBuf(buf, v5, pos);
        NumberConverter.writeBuf(buf, v4, pos + 3);
        NumberConverter.writeBuf(buf, v3, pos + 6);
        NumberConverter.writeBuf(buf, v2, pos + 9);
        NumberConverter.writeBuf(buf, v1, pos + 12);
        return pos + 15;
    }

    public static void serialize(long[] values, JsonWriter sw) {
        if (values == null) {
            sw.writeNull();
        } else if (values.length == 0) {
            sw.writeAscii("[]");
        } else {
            byte[] buf = sw.ensureCapacity(values.length * 21 + 2);
            int position = sw.size();
            buf[position++] = 91;
            position = NumberConverter.serialize(buf, position, values[0]);
            for (int i = 1; i < values.length; ++i) {
                buf[position++] = 44;
                position = NumberConverter.serialize(buf, position, values[i]);
            }
            buf[position++] = 93;
            sw.advance(position - sw.size());
        }
    }

    public static long deserializeLong(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberConverter.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader).longValue();
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        int i = start;
        long value = 0L;
        if (ch == 45) {
            for (i = start + 1; i < end; ++i) {
                int ind = buf[i] - 48;
                value = (value << 3) + (value << 1) - (long)ind;
                if (ind >= 0 && ind <= 9) continue;
                return NumberConverter.parseLongGeneric(reader, start, end);
            }
            return value;
        }
        if (ch == 43) {
            i = start + 1;
        }
        while (i < end) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) + (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseLongGeneric(reader, start, end);
            }
            ++i;
        }
        return value;
    }

    private static long parseLongGeneric(JsonReader reader, int start, int end) throws IOException {
        BigDecimal v = NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
        if (v.scale() <= 0) {
            return v.longValue();
        }
        throw new IOException("Error parsing long number at position: " + reader.positionInStream(end - start) + ". Found decimal value: " + v);
    }

    public static ArrayList<Long> deserializeLongCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(LongReader);
    }

    public static void deserializeLongCollection(JsonReader reader, Collection<Long> res) throws IOException {
        reader.deserializeCollection(LongReader, res);
    }

    public static ArrayList<Long> deserializeLongNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(LongReader);
    }

    public static void deserializeLongNullableCollection(JsonReader reader, Collection<Long> res) throws IOException {
        reader.deserializeNullableCollection(LongReader, res);
    }

    public static void serializeNullable(BigDecimal value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            sw.writeAscii(value.toString());
        }
    }

    public static void serialize(BigDecimal value, JsonWriter sw) {
        sw.writeAscii(value.toString());
    }

    public static BigDecimal deserializeDecimal(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberConverter.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            if (len == reader.tmpLength) {
                NumberInfo info = NumberConverter.readLongNumber(reader, start);
                return NumberConverter.parseNumberGeneric(info.buffer, info.length, reader);
            }
            return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), len, reader);
        }
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            return NumberConverter.parseNegativeDecimal(buf, reader, start, end);
        }
        if (ch == 43) {
            return NumberConverter.parsePositiveDecimal(buf, reader, start, end, start + 1);
        }
        return NumberConverter.parsePositiveDecimal(buf, reader, start, end, start);
    }

    private static BigDecimal parsePositiveDecimal(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        long value = 0L;
        int ch = 32;
        while (i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69) {
            int ind = ch - 48;
            value = (value << 3) + (value << 1) + (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
            }
            ++i;
        }
        if (i == end) {
            return BigDecimal.valueOf(value);
        }
        if (ch == 46) {
            int dp = ++i;
            while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                int ind = ch - 48;
                value = (value << 3) + (value << 1) + (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            if (i == end) {
                return BigDecimal.valueOf(value, end - dp);
            }
            if (ch == 101 || ch == 69) {
                int ep = i++;
                ch = buf[i];
                int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
                return BigDecimal.valueOf(value, ep - dp - exp);
            }
            return BigDecimal.valueOf(value, end - dp);
        }
        if (ch == 101 || ch == 69) {
            int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
            return BigDecimal.valueOf(value, -exp);
        }
        return BigDecimal.valueOf(value);
    }

    private static BigDecimal parseNegativeDecimal(byte[] buf, JsonReader reader, int start, int end) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        for (i = start + 1; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            value = (value << 3) + (value << 1) - (long)ind;
            if (ind >= 0 && ind <= 9) continue;
            return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
        }
        if (i == end) {
            return BigDecimal.valueOf(value);
        }
        if (ch == 46) {
            int dp = ++i;
            while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                int ind = ch - 48;
                value = (value << 3) + (value << 1) - (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            if (i == end) {
                return BigDecimal.valueOf(value, end - dp);
            }
            if (ch == 101 || ch == 69) {
                int ep = i++;
                ch = buf[i];
                int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
                return BigDecimal.valueOf(value, ep - dp - exp);
            }
            return BigDecimal.valueOf(value, end - dp);
        }
        if (ch == 101 || ch == 69) {
            int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
            return BigDecimal.valueOf(value, -exp);
        }
        return BigDecimal.valueOf(value);
    }

    public static Number deserializeNumber(JsonReader reader) throws IOException {
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            if (len == reader.tmpLength) {
                NumberInfo tmp = NumberConverter.readLongNumber(reader, start);
                return NumberConverter.parseNumberGeneric(tmp.buffer, tmp.length, reader);
            }
            return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), len, reader);
        }
        byte[] buf = reader.buffer;
        byte ch = buf[0];
        if (ch == 45) {
            return NumberConverter.parseNegativeNumber(buf, reader, start, end);
        }
        if (ch == 43) {
            return NumberConverter.parsePositiveNumber(buf, reader, start, end, start + 1);
        }
        return NumberConverter.parsePositiveNumber(buf, reader, start, end, start);
    }

    private static Number parsePositiveNumber(byte[] buf, JsonReader reader, int start, int end, int i) throws IOException {
        long value = 0L;
        int ch = 32;
        while (i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69) {
            int ind = ch - 48;
            value = (value << 3) + (value << 1) + (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
            }
            ++i;
        }
        if (i == end) {
            return value;
        }
        if (ch == 46) {
            int dp = ++i;
            while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                int ind = ch - 48;
                value = (value << 3) + (value << 1) + (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            if (i == end) {
                return (double)value / POW_10[end - dp];
            }
            if (ch == 101 || ch == 69) {
                int ep = i++;
                ch = buf[i];
                int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
                return BigDecimal.valueOf(value, ep - dp - exp);
            }
            return BigDecimal.valueOf(value, end - dp);
        }
        if (ch == 101 || ch == 69) {
            int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
            return BigDecimal.valueOf(value, -exp);
        }
        return BigDecimal.valueOf(value);
    }

    private static Number parseNegativeNumber(byte[] buf, JsonReader reader, int start, int end) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        for (i = start + 1; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            value = (value << 3) + (value << 1) - (long)ind;
            if (ind >= 0 && ind <= 9) continue;
            return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
        }
        if (i == end) {
            return value;
        }
        if (ch == 46) {
            int dp = ++i;
            while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                int ind = ch - 48;
                value = (value << 3) + (value << 1) - (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start), end - start, reader);
                }
                ++i;
            }
            if (i == end) {
                return (double)value / POW_10[end - dp];
            }
            if (ch == 101 || ch == 69) {
                int ep = i++;
                ch = buf[i];
                int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
                return BigDecimal.valueOf(value, ep - dp - exp);
            }
            return BigDecimal.valueOf(value, end - dp);
        }
        if (ch == 101 || ch == 69) {
            int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, start, end, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, start, end, i + 1) : NumberConverter.parsePositiveInt(buf, reader, start, end, i));
            return BigDecimal.valueOf(value, -exp);
        }
        return BigDecimal.valueOf(value);
    }

    public static ArrayList<BigDecimal> deserializeDecimalCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(DecimalReader);
    }

    public static void deserializeDecimalCollection(JsonReader reader, Collection<BigDecimal> res) throws IOException {
        reader.deserializeCollection(DecimalReader, res);
    }

    public static ArrayList<BigDecimal> deserializeDecimalNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(DecimalReader);
    }

    public static void deserializeDecimalNullableCollection(JsonReader reader, Collection<BigDecimal> res) throws IOException {
        reader.deserializeNullableCollection(DecimalReader, res);
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            NumberConverter.DIGITS[i] = (i < 10 ? 0x2000000 : (i < 100 ? 0x1000000 : 0)) + (i / 100 + 48 << 16) + (i / 10 % 10 + 48 << 8) + i % 10 + 48;
        }
        long tenPow = 1L;
        for (int i = 0; i < POW_10.length; ++i) {
            NumberConverter.POW_10[i] = tenPow;
            tenPow *= 10L;
        }
        MIN_INT = "-2147483648".getBytes();
        MIN_LONG = "-9223372036854775808".getBytes();
    }

    private static class NumberInfo {
        final char[] buffer;
        final int length;

        NumberInfo(char[] buffer, int length) {
            this.buffer = buffer;
            this.length = length;
        }
    }
}

