/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import com.dslplatform.json.AndroidGeomConverter;
import com.dslplatform.json.BinaryConverter;
import com.dslplatform.json.BoolConverter;
import com.dslplatform.json.Configuration;
import com.dslplatform.json.JavaGeomConverter;
import com.dslplatform.json.JodaTimeConverter;
import com.dslplatform.json.JsonObject;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonStreamReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NetConverter;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.StringConverter;
import com.dslplatform.json.UUIDConverter;
import com.dslplatform.json.XmlConverter;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.w3c.dom.Element;

public class DslJson<TContext> {
    protected final TContext context;
    protected final Fallback<TContext> fallback;
    static final JsonReader.ReadObject<Object> ObjectReader = new JsonReader.ReadObject<Object>(){

        @Override
        public Object read(JsonReader reader) throws IOException {
            return DslJson.deserializeObject(reader);
        }
    };
    static final JsonReader.ReadObject<Collection> CollectionReader = new JsonReader.ReadObject<Collection>(){

        @Override
        public Collection read(JsonReader reader) throws IOException {
            return DslJson.deserializeList(reader);
        }
    };
    static final JsonReader.ReadObject<LinkedHashMap> MapReader = new JsonReader.ReadObject<LinkedHashMap>(){

        @Override
        public LinkedHashMap read(JsonReader reader) throws IOException {
            return DslJson.deserializeMap(reader);
        }
    };
    private final ConcurrentHashMap<Class<?>, JsonReader.ReadJsonObject<JsonObject>> jsonObjectReaders = new ConcurrentHashMap();
    private final HashMap<Type, JsonReader.ReadObject<?>> jsonReaders = new HashMap();
    private final HashMap<Type, JsonWriter.WriteObject<?>> jsonWriters = new HashMap();
    private final ConcurrentMap<Class<?>, Class<?>> writerMap = new ConcurrentHashMap();
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};

    public DslJson() {
        this(null, false, false, false, null, ServiceLoader.load(Configuration.class));
    }

    public DslJson(TContext context, boolean androidSpecifics, boolean javaSpecifics, boolean jodaTime, Fallback<TContext> fallback, Iterable<Configuration> serializers) {
        this.context = context;
        this.fallback = fallback;
        this.registerReader(byte[].class, BinaryConverter.Base64Reader);
        this.registerWriter(byte[].class, BinaryConverter.Base64Writer);
        this.registerReader(Boolean.TYPE, BoolConverter.BooleanReader);
        this.registerReader(Boolean.class, BoolConverter.BooleanReader);
        this.registerWriter(Boolean.TYPE, BoolConverter.BooleanWriter);
        this.registerWriter(Boolean.class, BoolConverter.BooleanWriter);
        if (androidSpecifics) {
            DslJson.registerAndroidSpecifics(this);
        }
        if (javaSpecifics) {
            DslJson.registerJavaSpecifics(this);
        }
        if (jodaTime) {
            DslJson.registerJodaConverters(this);
        }
        this.registerReader(LinkedHashMap.class, MapReader);
        this.registerReader(HashMap.class, MapReader);
        this.registerReader(Map.class, MapReader);
        this.registerWriter(Map.class, new JsonWriter.WriteObject<Map>(){

            @Override
            public void write(JsonWriter writer, Map value) {
                try {
                    DslJson.this.serializeMap(value, writer);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        this.registerReader(URI.class, NetConverter.UriReader);
        this.registerWriter(URI.class, NetConverter.UriWriter);
        this.registerReader(InetAddress.class, NetConverter.AddressReader);
        this.registerWriter(InetAddress.class, NetConverter.AddressWriter);
        this.registerReader(Double.TYPE, NumberConverter.DoubleReader);
        this.registerWriter(Double.TYPE, NumberConverter.DoubleWriter);
        this.registerReader(Double.class, NumberConverter.DoubleReader);
        this.registerWriter(Double.class, NumberConverter.DoubleWriter);
        this.registerReader(Float.TYPE, NumberConverter.FloatReader);
        this.registerWriter(Float.TYPE, NumberConverter.FloatWriter);
        this.registerReader(Float.class, NumberConverter.FloatReader);
        this.registerWriter(Float.class, NumberConverter.FloatWriter);
        this.registerReader(Integer.TYPE, NumberConverter.IntReader);
        this.registerWriter(Integer.TYPE, NumberConverter.IntWriter);
        this.registerReader(Integer.class, NumberConverter.IntReader);
        this.registerWriter(Integer.class, NumberConverter.IntWriter);
        this.registerReader(Long.TYPE, NumberConverter.LongReader);
        this.registerWriter(Long.TYPE, NumberConverter.LongWriter);
        this.registerReader(Long.class, NumberConverter.LongReader);
        this.registerWriter(Long.class, NumberConverter.LongWriter);
        this.registerReader(BigDecimal.class, NumberConverter.DecimalReader);
        this.registerWriter(BigDecimal.class, NumberConverter.DecimalWriter);
        this.registerReader(String.class, StringConverter.Reader);
        this.registerWriter(String.class, StringConverter.Writer);
        this.registerReader(UUID.class, UUIDConverter.Reader);
        this.registerWriter(UUID.class, UUIDConverter.Writer);
        this.registerReader(Element.class, XmlConverter.Reader);
        this.registerWriter(Element.class, XmlConverter.Writer);
        this.registerReader(Number.class, NumberConverter.NumberReader);
        if (serializers != null) {
            boolean found = false;
            for (Configuration serializer : serializers) {
                serializer.configure(this);
                found = true;
            }
            if (!found) {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> external = loader.loadClass("dsl_json.json.ExternalSerialization");
                    Configuration instance = (Configuration)external.newInstance();
                    instance.configure(this);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static void registerAndroidSpecifics(DslJson json) {
        json.registerReader(PointF.class, AndroidGeomConverter.LocationReader);
        json.registerWriter(PointF.class, AndroidGeomConverter.LocationWriter);
        json.registerReader(Point.class, AndroidGeomConverter.PointReader);
        json.registerWriter(Point.class, AndroidGeomConverter.PointWriter);
        json.registerReader(Rect.class, AndroidGeomConverter.RectangleReader);
        json.registerWriter(Rect.class, AndroidGeomConverter.RectangleWriter);
        json.registerReader(Bitmap.class, AndroidGeomConverter.ImageReader);
        json.registerWriter(Bitmap.class, AndroidGeomConverter.ImageWriter);
    }

    static void registerJodaConverters(DslJson json) {
        json.registerReader(LocalDate.class, JodaTimeConverter.LocalDateReader);
        json.registerWriter(LocalDate.class, JodaTimeConverter.LocalDateWriter);
        json.registerReader(DateTime.class, JodaTimeConverter.DateTimeReader);
        json.registerWriter(DateTime.class, JodaTimeConverter.DateTimeWriter);
    }

    static void registerJavaSpecifics(DslJson json) {
        json.registerReader(Point2D.Double.class, JavaGeomConverter.LocationReader);
        json.registerReader(Point2D.class, JavaGeomConverter.LocationReader);
        json.registerWriter(Point2D.class, JavaGeomConverter.LocationWriter);
        json.registerReader(java.awt.Point.class, JavaGeomConverter.PointReader);
        json.registerWriter(java.awt.Point.class, JavaGeomConverter.PointWriter);
        json.registerReader(Rectangle2D.Double.class, JavaGeomConverter.RectangleReader);
        json.registerReader(Rectangle2D.class, JavaGeomConverter.RectangleReader);
        json.registerWriter(Rectangle2D.class, JavaGeomConverter.RectangleWriter);
        json.registerReader(BufferedImage.class, JavaGeomConverter.ImageReader);
        json.registerReader(Image.class, JavaGeomConverter.ImageReader);
        json.registerWriter(Image.class, JavaGeomConverter.ImageWriter);
    }

    protected static boolean isNull(int size, byte[] body) {
        return size == 4 && body[0] == 110 && body[1] == 117 && body[2] == 108 && body[3] == 108;
    }

    public <T, S extends T> void registerReader(Class<T> manifest, JsonReader.ReadObject<S> reader) {
        this.jsonReaders.put(manifest, reader);
    }

    public void registerReader(Type manifest, JsonReader.ReadObject<?> reader) {
        this.jsonReaders.put(manifest, reader);
    }

    public <T> void registerWriter(Class<T> manifest, JsonWriter.WriteObject<T> writer) {
        this.writerMap.put(manifest, manifest);
        this.jsonWriters.put(manifest, writer);
    }

    public void registerWriter(Type manifest, JsonWriter.WriteObject<?> writer) {
        this.jsonWriters.put(manifest, writer);
    }

    protected JsonWriter.WriteObject<?> tryFindWriter(Type manifest) {
        Class found = (Class)this.writerMap.get(manifest);
        if (found != null) {
            return this.jsonWriters.get(found);
        }
        if (!(manifest instanceof Class)) {
            return null;
        }
        Class container = (Class)manifest;
        ArrayList signatures = new ArrayList();
        DslJson.findAllSignatures(container, signatures);
        for (Class<?> sig : signatures) {
            JsonWriter.WriteObject<?> writer = this.jsonWriters.get(sig);
            if (writer == null) continue;
            this.writerMap.putIfAbsent(container, sig);
            return writer;
        }
        return null;
    }

    protected JsonReader.ReadObject<?> tryFindReader(Type manifest) {
        return this.jsonReaders.get(manifest);
    }

    private static void findAllSignatures(Class<?> manifest, ArrayList<Class<?>> found) {
        if (found.contains(manifest)) {
            return;
        }
        found.add(manifest);
        Class<?> superClass = manifest.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            DslJson.findAllSignatures(superClass, found);
        }
        for (Class<?> iface : manifest.getInterfaces()) {
            DslJson.findAllSignatures(iface, found);
        }
    }

    protected final JsonReader.ReadJsonObject<JsonObject> getObjectReader(Class<?> manifest) {
        try {
            JsonReader.ReadJsonObject reader = this.jsonObjectReaders.get(manifest);
            if (reader == null) {
                try {
                    reader = (JsonReader.ReadJsonObject)manifest.getField("JSON_READER").get(null);
                }
                catch (Exception ignore) {
                    return null;
                }
                this.jsonObjectReaders.putIfAbsent(manifest, reader);
            }
            return reader;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public void serializeMap(Map<String, Object> value, JsonWriter sw) throws IOException {
        sw.writeByte((byte)123);
        int size = value.size();
        if (size > 0) {
            Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
            Map.Entry<String, Object> kv = iterator.next();
            sw.writeString(kv.getKey());
            sw.writeByte((byte)58);
            this.serialize(sw, kv.getValue());
            for (int i = 1; i < size; ++i) {
                sw.writeByte((byte)44);
                kv = iterator.next();
                sw.writeString(kv.getKey());
                sw.writeByte((byte)58);
                this.serialize(sw, kv.getValue());
            }
        }
        sw.writeByte((byte)125);
    }

    public static Object deserializeObject(JsonReader reader) throws IOException {
        switch (reader.last()) {
            case 110: {
                if (!reader.wasNull()) {
                    throw reader.expecting("null");
                }
                return null;
            }
            case 116: {
                if (!reader.wasTrue()) {
                    throw reader.expecting("true");
                }
                return true;
            }
            case 102: {
                if (!reader.wasFalse()) {
                    throw reader.expecting("false");
                }
                return false;
            }
            case 34: {
                return reader.readString();
            }
            case 123: {
                return DslJson.deserializeMap(reader);
            }
            case 91: {
                return DslJson.deserializeList(reader);
            }
        }
        return NumberConverter.deserializeNumber(reader);
    }

    public static ArrayList<Object> deserializeList(JsonReader reader) throws IOException {
        if (reader.last() != 91) {
            throw reader.expecting("[");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 93) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> res = new ArrayList<Object>(4);
        res.add(DslJson.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            res.add(DslJson.deserializeObject(reader));
        }
        if (nextToken != 93) {
            throw reader.expecting("]", nextToken);
        }
        return res;
    }

    public static LinkedHashMap<String, Object> deserializeMap(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.expecting("{");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        String key = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw reader.expecting(":", nextToken);
        }
        reader.getNextToken();
        res.put(key, DslJson.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            key = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw reader.expecting(":", nextToken);
            }
            reader.getNextToken();
            res.put(key, DslJson.deserializeObject(reader));
        }
        if (nextToken != 125) {
            throw reader.expecting("}", nextToken);
        }
        return res;
    }

    private static Object convertResultToArray(Class<?> elementType, List<?> result) {
        if (elementType.isPrimitive()) {
            if (Boolean.TYPE.equals(elementType)) {
                boolean[] array = new boolean[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Boolean)result.get(i);
                }
                return array;
            }
            if (Integer.TYPE.equals(elementType)) {
                int[] array = new int[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Integer)result.get(i);
                }
                return array;
            }
            if (Long.TYPE.equals(elementType)) {
                long[] array = new long[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Long)result.get(i);
                }
                return array;
            }
            if (Short.TYPE.equals(elementType)) {
                short[] array = new short[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Short)result.get(i);
                }
                return array;
            }
            if (Byte.TYPE.equals(elementType)) {
                byte[] array = new byte[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Byte)result.get(i);
                }
                return array;
            }
            if (Float.TYPE.equals(elementType)) {
                float[] array = new float[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = ((Float)result.get(i)).floatValue();
                }
                return array;
            }
            if (Double.TYPE.equals(elementType)) {
                double[] array = new double[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Double)result.get(i);
                }
                return array;
            }
            if (Character.TYPE.equals(elementType)) {
                char[] array = new char[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = ((Character)result.get(i)).charValue();
                }
                return array;
            }
        }
        return result.toArray((Object[])Array.newInstance(elementType, result.size()));
    }

    public final boolean canSerialize(Type manifest) {
        if (manifest instanceof Class) {
            Class content = (Class)manifest;
            if (JsonObject.class.isAssignableFrom(content)) {
                return true;
            }
            if (JsonObject[].class.isAssignableFrom(content)) {
                return true;
            }
            if (this.tryFindWriter(manifest) != null) {
                return true;
            }
            if (content.isArray()) {
                return !content.getComponentType().isArray() && !Collection.class.isAssignableFrom(content.getComponentType()) && this.canSerialize(content.getComponentType());
            }
        }
        if (manifest instanceof ParameterizedType) {
            Class container;
            ParameterizedType pt = (ParameterizedType)manifest;
            if (pt.getActualTypeArguments().length == 1 && pt.getRawType() instanceof Class && ((container = (Class)pt.getRawType()).isArray() || Collection.class.isAssignableFrom(container))) {
                Type content = pt.getActualTypeArguments()[0];
                return content instanceof Class && JsonObject.class.isAssignableFrom((Class)content) || this.tryFindWriter(content) != null;
            }
        } else if (manifest instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)manifest;
            return gat.getGenericComponentType() instanceof Class && JsonObject.class.isAssignableFrom((Class)gat.getGenericComponentType()) || this.tryFindWriter(gat.getGenericComponentType()) != null;
        }
        return false;
    }

    public final boolean canDeserialize(Type manifest) {
        if (manifest instanceof Class) {
            Class objectType = (Class)manifest;
            if (JsonObject.class.isAssignableFrom(objectType)) {
                return this.getObjectReader(objectType) != null;
            }
            if (objectType.isArray()) {
                return !objectType.getComponentType().isArray() && !Collection.class.isAssignableFrom(objectType.getComponentType()) && this.canDeserialize(objectType.getComponentType());
            }
        }
        if (this.tryFindReader(manifest) != null) {
            return true;
        }
        if (manifest instanceof ParameterizedType) {
            Class container;
            ParameterizedType pt = (ParameterizedType)manifest;
            if (pt.getActualTypeArguments().length == 1 && pt.getRawType() instanceof Class && ((container = (Class)pt.getRawType()).isArray() || Collection.class.isAssignableFrom(container))) {
                Type content = pt.getActualTypeArguments()[0];
                if (this.tryFindReader(content) != null) {
                    return true;
                }
                if (content instanceof Class) {
                    Class objectType = (Class)content;
                    return JsonObject.class.isAssignableFrom(objectType) && this.getObjectReader(objectType) != null;
                }
            }
        } else if (manifest instanceof GenericArrayType) {
            Type content = ((GenericArrayType)manifest).getGenericComponentType();
            if (this.tryFindReader(content) != null) {
                return true;
            }
            if (content instanceof Class) {
                Class objectType = (Class)content;
                return JsonObject.class.isAssignableFrom(objectType) && this.getObjectReader(objectType) != null;
            }
        }
        return false;
    }

    public <TResult> TResult deserialize(Class<TResult> manifest, byte[] body, int size) throws IOException {
        JsonReader.ReadJsonObject<JsonObject> objectReader;
        if (DslJson.isNull(size, body)) {
            return null;
        }
        if (size == 2 && body[0] == 123 && body[1] == 125 && !manifest.isInterface()) {
            try {
                return manifest.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }
        JsonReader<TContext> json = new JsonReader<TContext>(body, size, this.context);
        json.getNextToken();
        if (json.wasNull()) {
            return null;
        }
        if (JsonObject.class.isAssignableFrom(manifest) && (objectReader = this.getObjectReader(manifest)) != null) {
            if (json.last() == 123) {
                json.getNextToken();
                return (TResult)objectReader.deserialize(json);
            }
            throw json.expecting("{");
        }
        JsonReader.ReadObject<?> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            Object result = simpleReader.read(json);
            if (json.getCurrentIndex() > json.length()) {
                throw new IOException("JSON string was not closed with a double quote");
            }
            return (TResult)result;
        }
        if (manifest.isArray()) {
            if (json.last() != 91) {
                throw json.expecting("[");
            }
            Class<?> elementManifest = manifest.getComponentType();
            List<?> list = this.deserializeList(elementManifest, body, size);
            if (list == null) {
                return null;
            }
            return (TResult)DslJson.convertResultToArray(elementManifest, list);
        }
        if (this.fallback != null) {
            return (TResult)this.fallback.deserialize(this.context, manifest, body, size);
        }
        throw this.createErrorMessage(manifest);
    }

    public Object deserialize(Type manifest, byte[] body, int size) throws IOException {
        if (manifest instanceof Class) {
            return this.deserialize((Class)manifest, body, size);
        }
        if (DslJson.isNull(size, body)) {
            return null;
        }
        JsonReader<TContext> json = new JsonReader<TContext>(body, size, this.context);
        json.getNextToken();
        if (json.wasNull()) {
            return null;
        }
        Object result = this.deserializeWith(manifest, json);
        if (result != null) {
            return result;
        }
        if (this.fallback != null) {
            return this.fallback.deserialize(this.context, manifest, body, size);
        }
        throw new IOException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\n" + "Try initializing DslJson with custom fallback in case of unsupported objects or register specified type using registerReader into " + this.getClass());
    }

    private Object deserializeWith(Type manifest, JsonReader json) throws IOException {
        JsonReader.ReadObject<?> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            Object result = simpleReader.read(json);
            if (json.getCurrentIndex() > json.length()) {
                throw new IOException("JSON string was not closed with a double quote");
            }
            return result;
        }
        if (manifest instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)manifest;
            if (pt.getActualTypeArguments().length == 1 && pt.getRawType() instanceof Class) {
                Type content = pt.getActualTypeArguments()[0];
                Class container = (Class)pt.getRawType();
                if (container.isArray() || Collection.class.isAssignableFrom(container)) {
                    JsonReader.ReadJsonObject<JsonObject> objectReader;
                    Class contentType;
                    if (json.last() != 91) {
                        throw json.expecting("[");
                    }
                    if (json.getNextToken() == 93) {
                        if (container.isArray()) {
                            DslJson.returnEmptyArray(content);
                        }
                        return new ArrayList(0);
                    }
                    JsonReader.ReadObject<?> contentReader = this.tryFindReader(content);
                    if (contentReader != null) {
                        ArrayList result = json.deserializeNullableCollection(contentReader);
                        if (container.isArray()) {
                            return DslJson.returnAsArray(content, result);
                        }
                        return result;
                    }
                    if (content instanceof Class && JsonObject.class.isAssignableFrom(contentType = (Class)content) && (objectReader = this.getObjectReader(contentType)) != null) {
                        ArrayList<JsonObject> result = json.deserializeNullableCollection(objectReader);
                        if (container.isArray()) {
                            return result.toArray((Object[])Array.newInstance(contentType, result.size()));
                        }
                        return result;
                    }
                }
            }
        } else if (manifest instanceof GenericArrayType) {
            JsonReader.ReadJsonObject<JsonObject> objectReader;
            Class contentType;
            if (json.last() != 91) {
                throw json.expecting("[");
            }
            Type content = ((GenericArrayType)manifest).getGenericComponentType();
            if (json.getNextToken() == 93) {
                return DslJson.returnEmptyArray(content);
            }
            JsonReader.ReadObject<?> contentReader = this.tryFindReader(content);
            if (contentReader != null) {
                ArrayList result = json.deserializeNullableCollection(contentReader);
                return DslJson.returnAsArray(content, result);
            }
            if (content instanceof Class && JsonObject.class.isAssignableFrom(contentType = (Class)content) && (objectReader = this.getObjectReader(contentType)) != null) {
                ArrayList<JsonObject> result = json.deserializeNullableCollection(objectReader);
                return result.toArray((Object[])Array.newInstance(contentType, result.size()));
            }
        }
        return null;
    }

    private static Object returnAsArray(Type content, ArrayList<?> result) {
        ParameterizedType cpt;
        if (content instanceof Class) {
            return DslJson.convertResultToArray((Class)content, result);
        }
        if (content instanceof ParameterizedType && (cpt = (ParameterizedType)content).getRawType() instanceof Class) {
            return result.toArray((Object[])Array.newInstance((Class)cpt.getRawType(), result.size()));
        }
        return result.toArray();
    }

    private static Object returnEmptyArray(Type content) {
        ParameterizedType pt;
        if (content instanceof Class) {
            return Array.newInstance((Class)content, 0);
        }
        if (content instanceof ParameterizedType && (pt = (ParameterizedType)content).getRawType() instanceof Class) {
            return Array.newInstance((Class)pt.getRawType(), 0);
        }
        return new Object[0];
    }

    private IOException createErrorMessage(Class<?> manifest) throws IOException {
        ArrayList signatures = new ArrayList();
        DslJson.findAllSignatures(manifest, signatures);
        for (Class<?> sig : signatures) {
            if (!this.jsonReaders.containsKey(sig)) continue;
            if (sig.equals(manifest)) {
                return new IOException("Reader for provided type: " + manifest + " is disabled and fallback serialization is not registered (converter is registered as null).\n" + "Try initializing system with custom fallback or don't register null for " + manifest);
            }
            return new IOException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\n" + "Found reader for: " + sig + " so try deserializing into that instead?\n" + "Alternatively, try initializing system with custom fallback or register specified type using registerReader into " + this.getClass());
        }
        return new IOException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\n" + "Try initializing DslJson with custom fallback in case of unsupported objects or register specified type using registerReader into " + this.getClass());
    }

    public <TResult> List<TResult> deserializeList(Class<TResult> manifest, byte[] body, int size) throws IOException {
        JsonReader.ReadJsonObject<JsonObject> reader;
        if (DslJson.isNull(size, body)) {
            return null;
        }
        if (size == 2 && body[0] == 91 && body[1] == 93) {
            return new ArrayList(0);
        }
        JsonReader<TContext> json = new JsonReader<TContext>(body, size, this.context);
        if (json.getNextToken() != 91) {
            if (json.wasNull()) {
                return null;
            }
            throw json.expecting("[");
        }
        if (json.getNextToken() == 93) {
            return new ArrayList(0);
        }
        if (JsonObject.class.isAssignableFrom(manifest) && (reader = this.getObjectReader(manifest)) != null) {
            return json.deserializeNullableCollection(reader);
        }
        JsonReader.ReadObject<?> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            return json.deserializeNullableCollection(simpleReader);
        }
        if (this.fallback != null) {
            Object array = Array.newInstance(manifest, 0);
            Object[] result = (Object[])this.fallback.deserialize(this.context, array.getClass(), body, size);
            if (result == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>(result.length);
            for (Object aResult : result) {
                list.add(aResult);
            }
            return list;
        }
        throw this.createErrorMessage(manifest);
    }

    public <TResult> List<TResult> deserializeList(Class<TResult> manifest, InputStream stream, byte[] buffer) throws IOException {
        JsonReader.ReadJsonObject<JsonObject> reader;
        JsonStreamReader<TContext> json = new JsonStreamReader<TContext>(stream, buffer, this.context);
        if (json.getNextToken() != 91) {
            if (json.wasNull()) {
                return null;
            }
            throw json.expecting("[");
        }
        if (json.getNextToken() == 93) {
            return new ArrayList(0);
        }
        if (JsonObject.class.isAssignableFrom(manifest) && (reader = this.getObjectReader(manifest)) != null) {
            return json.deserializeNullableCollection(reader);
        }
        JsonReader.ReadObject<?> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            return json.deserializeNullableCollection(simpleReader);
        }
        if (this.fallback != null) {
            Object array = Array.newInstance(manifest, 0);
            Object[] result = (Object[])this.fallback.deserialize(this.context, array.getClass(), json.streamFromStart());
            if (result == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>(result.length);
            for (Object aResult : result) {
                list.add(aResult);
            }
            return list;
        }
        throw this.createErrorMessage(manifest);
    }

    public <TResult> TResult deserialize(Class<TResult> manifest, InputStream stream, byte[] buffer) throws IOException {
        JsonReader.ReadJsonObject<JsonObject> objectReader;
        JsonStreamReader<TContext> json = new JsonStreamReader<TContext>(stream, buffer, this.context);
        json.getNextToken();
        if (json.wasNull()) {
            return null;
        }
        if (JsonObject.class.isAssignableFrom(manifest) && (objectReader = this.getObjectReader(manifest)) != null) {
            if (json.last() == 123) {
                json.getNextToken();
                return (TResult)objectReader.deserialize(json);
            }
            throw json.expecting("{");
        }
        JsonReader.ReadObject<?> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            Object result = simpleReader.read(json);
            if (json.getCurrentIndex() > json.length()) {
                throw new IOException("JSON string was not closed with a double quote");
            }
            return (TResult)result;
        }
        if (manifest.isArray()) {
            JsonReader.ReadJsonObject<JsonObject> objectReader2;
            if (json.last() != 91) {
                throw json.expecting("[");
            }
            Class<?> elementManifest = manifest.getComponentType();
            if (json.getNextToken() == 93) {
                return (TResult)Array.newInstance(elementManifest, 0);
            }
            if (JsonObject.class.isAssignableFrom(elementManifest) && (objectReader2 = this.getObjectReader(elementManifest)) != null) {
                ArrayList<JsonObject> list = json.deserializeNullableCollection(objectReader2);
                return (TResult)DslJson.convertResultToArray(elementManifest, list);
            }
            JsonReader.ReadObject<?> simpleElementReader = this.tryFindReader(elementManifest);
            if (simpleElementReader != null) {
                ArrayList list = json.deserializeNullableCollection(simpleElementReader);
                return (TResult)DslJson.convertResultToArray(elementManifest, list);
            }
        }
        if (this.fallback != null) {
            return (TResult)this.fallback.deserialize(this.context, manifest, json.streamFromStart());
        }
        throw this.createErrorMessage(manifest);
    }

    public Object deserialize(Type manifest, InputStream stream, byte[] buffer) throws IOException {
        if (manifest instanceof Class) {
            return this.deserialize((Class)manifest, stream, buffer);
        }
        JsonStreamReader<TContext> json = new JsonStreamReader<TContext>(stream, buffer, this.context);
        json.getNextToken();
        if (json.wasNull()) {
            return null;
        }
        Object result = this.deserializeWith(manifest, json);
        if (result != null) {
            return result;
        }
        if (this.fallback != null) {
            return this.fallback.deserialize(this.context, manifest, json.streamFromStart());
        }
        throw new IOException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\n" + "Try initializing DslJson with custom fallback in case of unsupported objects or register specified type using registerReader into " + this.getClass());
    }

    public <T extends JsonObject> void serialize(JsonWriter writer, T[] array) {
        if (array == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (array.length != 0) {
            T item = array[0];
            if (item != null) {
                item.serialize(writer, false);
            } else {
                writer.writeNull();
            }
            for (int i = 1; i < array.length; ++i) {
                writer.writeByte((byte)44);
                item = array[i];
                if (item != null) {
                    item.serialize(writer, false);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(JsonWriter writer, T[] array, int len) {
        if (array == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (len != 0) {
            T item = array[0];
            if (item != null) {
                item.serialize(writer, false);
            } else {
                writer.writeNull();
            }
            for (int i = 1; i < len; ++i) {
                writer.writeByte((byte)44);
                item = array[i];
                if (item != null) {
                    item.serialize(writer, false);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(JsonWriter writer, List<T> list) {
        if (list == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (list.size() != 0) {
            JsonObject item = (JsonObject)list.get(0);
            if (item != null) {
                item.serialize(writer, false);
            } else {
                writer.writeNull();
            }
            for (int i = 1; i < list.size(); ++i) {
                writer.writeByte((byte)44);
                item = (JsonObject)list.get(i);
                if (item != null) {
                    item.serialize(writer, false);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(JsonWriter writer, Collection<T> collection) {
        if (collection == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (!collection.isEmpty()) {
            Iterator<T> it = collection.iterator();
            JsonObject item = (JsonObject)it.next();
            if (item != null) {
                item.serialize(writer, false);
            } else {
                writer.writeNull();
            }
            while (it.hasNext()) {
                writer.writeByte((byte)44);
                item = (JsonObject)it.next();
                if (item != null) {
                    item.serialize(writer, false);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    public <T> boolean serialize(JsonWriter writer, Type manifest, Object value) {
        if (value == null) {
            writer.writeNull();
            return true;
        }
        if (value instanceof JsonObject) {
            ((JsonObject)value).serialize(writer, false);
            return true;
        }
        if (value instanceof JsonObject[]) {
            this.serialize(writer, (JsonObject[])value);
            return true;
        }
        JsonWriter.WriteObject<?> simpleWriter = this.tryFindWriter(manifest);
        if (simpleWriter != null) {
            simpleWriter.write(writer, value);
            return true;
        }
        Class container = null;
        if (manifest instanceof Class) {
            container = (Class)manifest;
        }
        if (container != null && container.isArray()) {
            if (Array.getLength(value) == 0) {
                writer.writeAscii("[]");
                return true;
            }
            Class<?> elementManifest = container.getComponentType();
            if (elementManifest.isPrimitive()) {
                if (elementManifest == Boolean.TYPE) {
                    BoolConverter.serialize((boolean[])value, writer);
                } else if (elementManifest == Integer.TYPE) {
                    NumberConverter.serialize((int[])value, writer);
                } else if (elementManifest == Long.TYPE) {
                    NumberConverter.serialize((long[])value, writer);
                } else if (elementManifest == Byte.TYPE) {
                    BinaryConverter.serialize((byte[])value, writer);
                } else if (elementManifest == Short.TYPE) {
                    NumberConverter.serialize((short[])value, writer);
                } else if (elementManifest == Float.TYPE) {
                    NumberConverter.serialize((float[])value, writer);
                } else if (elementManifest == Double.TYPE) {
                    NumberConverter.serialize((double[])value, writer);
                } else if (elementManifest == Character.TYPE) {
                    StringConverter.serialize(new String((char[])value), writer);
                } else {
                    return false;
                }
                return true;
            }
            JsonWriter.WriteObject<?> elementWriter = this.tryFindWriter(elementManifest);
            if (elementWriter != null) {
                writer.serialize((Object[])value, elementWriter);
                return true;
            }
        }
        if (value instanceof Collection) {
            Collection items = (Collection)value;
            if (items.isEmpty()) {
                writer.writeAscii("[]");
                return true;
            }
            Class<?> baseType = null;
            Iterator iterator = items.iterator();
            do {
                Class<?> elementType;
                Object item;
                if ((item = iterator.next()) == null || (elementType = item.getClass()) == baseType || baseType != null && !elementType.isAssignableFrom(baseType)) continue;
                baseType = elementType;
            } while (iterator.hasNext());
            if (baseType == null) {
                writer.writeByte((byte)91);
                writer.writeNull();
                for (int i = 1; i < items.size(); ++i) {
                    writer.writeAscii(",null");
                }
                writer.writeByte((byte)93);
                return true;
            }
            if (JsonObject.class.isAssignableFrom(baseType)) {
                this.serialize(writer, items);
                return true;
            }
            JsonWriter.WriteObject<?> elementWriter = this.tryFindWriter(baseType);
            if (elementWriter != null) {
                writer.serialize(items, elementWriter);
                return true;
            }
        }
        return false;
    }

    public final void serialize(Object value, OutputStream stream) throws IOException {
        if (value == null) {
            stream.write(NULL);
            return;
        }
        JsonWriter jw = new JsonWriter();
        Class<?> manifest = value.getClass();
        if (!this.serialize(jw, manifest, value)) {
            if (this.fallback == null) {
                throw new IOException("Unable to serialize provided object. Failed to find serializer for: " + manifest);
            }
            this.fallback.serialize(value, stream);
        } else {
            jw.toStream(stream);
        }
    }

    public final void serialize(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.writeNull();
            return;
        }
        Class<?> manifest = value.getClass();
        if (!this.serialize(writer, manifest, value)) {
            if (this.fallback == null) {
                throw new IOException("Unable to serialize provided object. Failed to find serializer for: " + manifest);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.fallback.serialize(value, stream);
            writer.writeAscii(stream.toByteArray());
        }
    }

    public static interface Fallback<TContext> {
        public void serialize(Object var1, OutputStream var2) throws IOException;

        public Object deserialize(TContext var1, Type var2, byte[] var3, int var4) throws IOException;

        public Object deserialize(TContext var1, Type var2, InputStream var3) throws IOException;
    }
}

