/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.patterns;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class Bytes {
    public final byte[] content;
    public final int length;
    public static final Bytes EMPTY = new Bytes(new byte[0], 0);
    private static final Charset utf8 = Charset.forName("UTF-8");

    public Bytes(byte[] byArray, int n) {
        this.content = byArray;
        this.length = n;
    }

    public void copyTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.content, 0, this.length);
    }

    public String toUtf8() {
        return new String(this.content, 0, this.length, utf8);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.content, this.length);
    }
}

