/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.MapConverter;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.StringConverter;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.storage.S3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class StorageConverter {
    public static final JsonReader.ReadObject<S3> S3Reader = new JsonReader.ReadObject<S3>(){

        public S3 read(JsonReader jsonReader) throws IOException {
            return StorageConverter.deserializeS3((JsonReader<ServiceLocator>)jsonReader);
        }
    };
    public static final JsonWriter.WriteObject<S3> S3Writer = new JsonWriter.WriteObject<S3>(){

        public void write(JsonWriter jsonWriter, S3 s3) {
            if (s3 == null) {
                jsonWriter.writeNull();
            } else {
                StorageConverter.serialize(s3, jsonWriter);
            }
        }
    };

    public static void serialize(S3 s3, JsonWriter jsonWriter) {
        jsonWriter.writeAscii("{\"Bucket\":");
        StringConverter.serializeNullable((String)s3.getBucket(), (JsonWriter)jsonWriter);
        jsonWriter.writeAscii(",\"Key\":");
        StringConverter.serializeNullable((String)s3.getKey(), (JsonWriter)jsonWriter);
        jsonWriter.writeAscii(",\"Length\":");
        NumberConverter.serialize((long)s3.getLength(), (JsonWriter)jsonWriter);
        jsonWriter.writeAscii(",\"Name\":");
        StringConverter.serializeNullable((String)s3.getName(), (JsonWriter)jsonWriter);
        jsonWriter.writeAscii(",\"MimeType\":");
        StringConverter.serializeNullable((String)s3.getMimeType(), (JsonWriter)jsonWriter);
        jsonWriter.writeAscii(",\"Metadata\":");
        MapConverter.serializeNullable(s3.getMetadata(), (JsonWriter)jsonWriter);
        jsonWriter.writeByte((byte)125);
    }

    public static S3 deserializeS3(JsonReader<ServiceLocator> jsonReader) throws IOException {
        String string = null;
        String string2 = null;
        long l = 0L;
        String string3 = null;
        String string4 = null;
        Map map = null;
        if (jsonReader.last() != 125) {
            jsonReader.getNextToken();
            String string5 = jsonReader.readString();
            if (jsonReader.getNextToken() != 58) {
                throw new IOException("Expecting ':' at " + jsonReader.getCurrentIndex());
            }
            jsonReader.getNextToken();
            if ("Bucket".equalsIgnoreCase(string5)) {
                string = StringConverter.deserializeNullable(jsonReader);
            } else if ("Key".equalsIgnoreCase(string5)) {
                string2 = StringConverter.deserializeNullable(jsonReader);
            } else if ("Length".equalsIgnoreCase(string5)) {
                l = NumberConverter.deserializeLong(jsonReader);
            } else if ("Name".equalsIgnoreCase(string5)) {
                string3 = StringConverter.deserializeNullable(jsonReader);
            } else if ("MimeType".equalsIgnoreCase(string5)) {
                string4 = StringConverter.deserializeNullable(jsonReader);
            } else if ("Metadata".equalsIgnoreCase(string5)) {
                map = MapConverter.deserialize(jsonReader);
            } else {
                jsonReader.skip();
            }
            while (jsonReader.getNextToken() == 44) {
                jsonReader.getNextToken();
                string5 = jsonReader.readString();
                if (jsonReader.getNextToken() != 58) {
                    throw new IOException("Expecting ':' at" + jsonReader.getCurrentIndex());
                }
                jsonReader.getNextToken();
                if ("Bucket".equalsIgnoreCase(string5)) {
                    string = StringConverter.deserializeNullable(jsonReader);
                    continue;
                }
                if ("Key".equalsIgnoreCase(string5)) {
                    string2 = StringConverter.deserializeNullable(jsonReader);
                    continue;
                }
                if ("Length".equalsIgnoreCase(string5)) {
                    l = NumberConverter.deserializeLong(jsonReader);
                    continue;
                }
                if ("Name".equalsIgnoreCase(string5)) {
                    string3 = StringConverter.deserializeNullable(jsonReader);
                    continue;
                }
                if ("MimeType".equalsIgnoreCase(string5)) {
                    string4 = StringConverter.deserializeNullable(jsonReader);
                    continue;
                }
                if ("Metadata".equalsIgnoreCase(string5)) {
                    map = MapConverter.deserialize(jsonReader);
                    continue;
                }
                jsonReader.skip();
            }
            if (jsonReader.last() != 125) {
                throw new IOException("Expecting '}' at " + jsonReader.getCurrentIndex());
            }
        }
        return new S3((ServiceLocator)jsonReader.context, string, string2, l, string3, string4, map);
    }

    public static ArrayList<S3> deserializeS3Collection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(S3Reader);
    }

    public static void deserializeS3Collection(JsonReader jsonReader, Collection<S3> collection) throws IOException {
        jsonReader.deserializeCollection(S3Reader, collection);
    }

    public static ArrayList<S3> deserializeS3NullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(S3Reader);
    }

    public static void deserializeS3NullableCollection(JsonReader jsonReader, Collection<S3> collection) throws IOException {
        jsonReader.deserializeNullableCollection(S3Reader, collection);
    }
}

