/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.Utils;
import com.dslplatform.json.XmlConverter;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.Bytes;
import com.dslplatform.patterns.History;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.patterns.Snapshot;
import com.dslplatform.storage.S3;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JacksonJsonSerialization
implements JsonSerialization {
    private static final String TEXT_NODE_TAG = "#text";
    private static final JsonSerializer<LocalDate> dateSerializer = new JsonSerializer<LocalDate>(){

        public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(localDate.toString());
        }
    };
    private static final JsonDeserializer<LocalDate> dateDeserializer = new JsonDeserializer<LocalDate>(){

        public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return DateTime.parse((String)jsonParser.getValueAsString()).toLocalDate();
        }
    };
    private static final JsonSerializer<DateTime> timestampSerializer = new JsonSerializer<DateTime>(){

        public void serialize(DateTime dateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(dateTime.toString());
        }
    };
    private static final JsonDeserializer<DateTime> timestampDeserializer = new JsonDeserializer<DateTime>(){

        public DateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return DateTime.parse((String)jsonParser.getValueAsString());
        }
    };
    private static final JsonSerializer<S3> s3Serializer = new JsonSerializer<S3>(){

        public void serialize(S3 s3, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("Bucket", s3.getBucket());
            jsonGenerator.writeStringField("Key", s3.getKey());
            jsonGenerator.writeNumberField("Length", s3.getLength());
            jsonGenerator.writeStringField("Name", s3.getName());
            jsonGenerator.writeStringField("MimeType", s3.getMimeType());
            jsonGenerator.writeObjectField("Metadata", s3.getMetadata());
            jsonGenerator.writeEndObject();
        }
    };
    private static final JsonDeserializer<S3> s3Deserializer = new JsonDeserializer<S3>(){

        public S3 deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Object object;
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new IOException("Expecting '{'. Found: " + jsonParser.getCurrentToken());
            }
            String string = null;
            String string2 = null;
            long l = 0L;
            String string3 = null;
            String string4 = null;
            Map map = null;
            while (jsonParser.nextToken() == JsonToken.FIELD_NAME) {
                object = jsonParser.getCurrentName();
                if ("Bucket".equalsIgnoreCase((String)object)) {
                    string = jsonParser.nextTextValue();
                    continue;
                }
                if ("Key".equalsIgnoreCase((String)object)) {
                    string2 = jsonParser.nextTextValue();
                    continue;
                }
                if ("Length".equalsIgnoreCase((String)object)) {
                    l = jsonParser.nextLongValue(0L);
                    continue;
                }
                if ("Name".equalsIgnoreCase((String)object)) {
                    string3 = jsonParser.nextTextValue();
                    continue;
                }
                if ("MimeType".equalsIgnoreCase((String)object)) {
                    string4 = jsonParser.nextTextValue();
                    continue;
                }
                if ("Metadata".equalsIgnoreCase((String)object)) {
                    JsonToken jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.START_OBJECT) {
                        map = (Map)jsonParser.readValueAs(HashMap.class);
                        continue;
                    }
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        map = null;
                        continue;
                    }
                    throw new IOException("Expecting '}'. Found: " + jsonParser.getCurrentToken());
                }
                jsonParser.skipChildren();
            }
            if (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
                throw new IOException("Expecting '}'. Found: " + jsonParser.getCurrentToken());
            }
            object = (ServiceLocator)deserializationContext.findInjectableValue((Object)"_serviceLocator", null, null);
            return new S3((ServiceLocator)object, string, string2, l, string3, string4, map);
        }
    };
    private static final JsonSerializer<Element> xmlSerializer = new JsonSerializer<Element>(){

        public void serialize(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            JacksonJsonSerialization.trimWhitespaceTextNodes(element);
            if (element == null) {
                return;
            }
            element.getChildNodes();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(element.getNodeName(), JacksonJsonSerialization.buildFromXml(element));
            jsonGenerator.writeObject(hashMap);
        }
    };
    private static final ThreadLocal<DocumentBuilder> documentBuilder = new ThreadLocal<DocumentBuilder>(){

        @Override
        public DocumentBuilder initialValue() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                return documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
        }
    };
    private static final JsonDeserializer<Element> xmlDeserializer = new JsonDeserializer<Element>(){

        public Element deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                try {
                    byte[] byArray = jsonParser.getValueAsString().getBytes("UTF-8");
                    return ((DocumentBuilder)documentBuilder.get()).parse(new ByteArrayInputStream(byArray)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(sAXException);
                }
            }
            HashMap hashMap = (HashMap)jsonParser.readValueAs(HashMap.class);
            if (hashMap == null) {
                return null;
            }
            return XmlConverter.mapToXml((Map)hashMap);
        }
    };
    private static final SimpleModule serializationModule = new SimpleModule("SerializationModule", new Version(1, 0, 0, "SNAPSHOT", "com.dslplatform", "dsl-client-java")).addSerializer(LocalDate.class, dateSerializer).addSerializer(Element.class, xmlSerializer).addSerializer(S3.class, s3Serializer).addSerializer(DateTime.class, timestampSerializer);
    private static final ObjectMapper serializationMapper = new ObjectMapper().registerModule((Module)serializationModule).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private static final TypeFactory typeFactory = serializationMapper.getTypeFactory();
    private final ObjectMapper deserializationMapper;
    private static final SimpleModule deserializationModule = new SimpleModule("DeserializationModule", new Version(1, 0, 0, "SNAPSHOT", "com.dslplatform", "dsl-client-java")).addDeserializer(LocalDate.class, dateDeserializer).addDeserializer(DateTime.class, timestampDeserializer).addDeserializer(S3.class, s3Deserializer).addDeserializer(Element.class, xmlDeserializer);

    private static void trimWhitespaceTextNodes(Node node) {
        if (node != null && node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node node2 = node.getChildNodes().item(i);
                if (node2.getNodeType() == 3 && node2.getNodeValue().trim().length() == 0) {
                    node.removeChild(node2);
                }
                JacksonJsonSerialization.trimWhitespaceTextNodes(node.getChildNodes().item(i));
            }
        }
    }

    private static Object buildFromXml(Element element) {
        Object object;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (!linkedHashMap.containsKey(string)) {
                linkedHashMap.put(string, new LinkedList());
            }
            ((LinkedList)linkedHashMap.get(string)).add(node);
        }
        if (n == 0 && element.getAttributes().getLength() == 0) {
            return !"".equals(element.getTextContent()) ? element.getTextContent() : null;
        }
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        int n2 = element.getAttributes().getLength();
        for (int i = 0; i < n2; ++i) {
            Node object22 = element.getAttributes().item(i);
            linkedHashMap2.put("@" + object22.getNodeName(), object22.getNodeValue());
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object = new Object[((LinkedList)entry.getValue()).size()];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                Node node = (Node)((LinkedList)entry.getValue()).get(i);
                object[i] = node instanceof Element ? JacksonJsonSerialization.buildFromXml((Element)node) : (!"".equals(node.getNodeValue()) ? node.getNodeValue() : null);
            }
            linkedHashMap2.put((String)entry.getKey(), ((Object[])object).length > 1 ? object : object[0]);
        }
        if (linkedHashMap2.size() == 1 && linkedHashMap.keySet().iterator().hasNext()) {
            String string = (String)linkedHashMap.keySet().iterator().next();
            if (string.equals(TEXT_NODE_TAG)) {
                return linkedHashMap2.get(string);
            }
            Object v = linkedHashMap2.get(string);
            if (v instanceof HashMap && ((HashMap)(object = (HashMap)v)).size() == 1 && ((HashMap)object).containsKey(string)) {
                return object;
            }
        }
        return linkedHashMap2;
    }

    static JavaType buildType(Class<?> clazz) {
        return typeFactory.constructType(clazz);
    }

    static JavaType buildGenericType(Class<?> clazz, Class<?> ... classArray) {
        return typeFactory.constructParametricType(clazz, (Class[])classArray);
    }

    static JavaType buildCollectionType(Class<? extends Collection> clazz, JavaType javaType) {
        return typeFactory.constructCollectionType(clazz, javaType);
    }

    static JavaType buildCollectionType(Class<? extends Collection> clazz, Class<?> clazz2) {
        return typeFactory.constructCollectionType(clazz, clazz2);
    }

    public JacksonJsonSerialization(ServiceLocator serviceLocator) {
        JacksonJsonSerialization.addPlatformDependentDeserializerModules(deserializationModule);
        JacksonJsonSerialization.addPlatformDependentSerializerModules(serializationModule);
        this.deserializationMapper = JacksonJsonSerialization.makeDeserializationObjectMapper(serviceLocator);
    }

    public <T> T deserialize(JavaType javaType, String string) throws IOException {
        return (T)this.deserializationMapper.readValue(string, javaType);
    }

    public <T> T deserialize(JavaType javaType, byte[] byArray) throws IOException {
        return (T)this.deserializationMapper.readValue(byArray, javaType);
    }

    public <T> T deserialize(JavaType javaType, byte[] byArray, int n) throws IOException {
        return (T)this.deserializationMapper.readValue(byArray, 0, n, javaType);
    }

    public <T> T deserialize(Type type, byte[] byArray, int n) throws IOException {
        JavaType javaType = this.deserializationMapper.getTypeFactory().constructType(type);
        return (T)this.deserializationMapper.readValue(byArray, 0, n, javaType);
    }

    public <T> T deserialize(Class<T> clazz, byte[] byArray) throws IOException {
        return (T)this.deserializationMapper.readValue(byArray, clazz);
    }

    public <T> T deserialize(Class<T> clazz, String string) throws IOException {
        return (T)this.deserializationMapper.readValue(string, clazz);
    }

    public <T> T deserialize(Type type, InputStream inputStream) throws IOException {
        JavaType javaType = this.deserializationMapper.getTypeFactory().constructType(type);
        return (T)this.deserializationMapper.readValue(inputStream, javaType);
    }

    public <T> T deserialize(JavaType javaType, InputStream inputStream) throws IOException {
        return (T)this.deserializationMapper.readValue(inputStream, javaType);
    }

    @Override
    public <T extends AggregateRoot> List<History<T>> deserializeHistoryList(Class<T> clazz, byte[] byArray, int n) throws IOException {
        JavaType javaType = JacksonJsonSerialization.buildCollectionType(ArrayList.class, JacksonJsonSerialization.buildGenericType(HistoryDelegate.class, clazz));
        List list = (List)this.deserializationMapper.readValue(byArray, 0, n, javaType);
        ArrayList<History<T>> arrayList = new ArrayList<History<T>>(list.size());
        for (HistoryDelegate historyDelegate : list) {
            List list2 = historyDelegate.Snapshots;
            ArrayList arrayList2 = new ArrayList(list2.size());
            for (SnapshotDelegate snapshotDelegate : list2) {
                arrayList2.add(new Snapshot(snapshotDelegate.At, snapshotDelegate.Action, snapshotDelegate.Value));
            }
            arrayList.add(new History(arrayList2));
        }
        return arrayList;
    }

    public static String serializeString(Object object) throws IOException {
        return serializationMapper.writer().writeValueAsString(object);
    }

    public static byte[] serializeBytes(Object object) throws IOException {
        return serializationMapper.writer().writeValueAsBytes(object);
    }

    public static void serialize(OutputStream outputStream, Object object) throws IOException {
        serializationMapper.writer().writeValue(outputStream, object);
    }

    public static void serializeTo(Writer writer, Object object) throws IOException {
        serializationMapper.writer().writeValue(writer, object);
    }

    private static ObjectMapper makeDeserializationObjectMapper(ServiceLocator serviceLocator) {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true).registerModule((Module)deserializationModule).setInjectableValues((InjectableValues)new InjectableValues.Std().addValue("_serviceLocator", (Object)serviceLocator));
    }

    private static void addPlatformDependentSerializerModules(SimpleModule simpleModule) {
        if (Utils.IS_ANDROID) {
            AndroidConverters.initAndroidSerializers(simpleModule);
        } else {
            JavaConverters.initJavaSerializers(simpleModule);
        }
    }

    private static void addPlatformDependentDeserializerModules(SimpleModule simpleModule) {
        if (Utils.IS_ANDROID) {
            AndroidConverters.initAndroidDeserializers(simpleModule);
        } else {
            JavaConverters.initJavaDeserializers(simpleModule);
        }
    }

    @Override
    public Bytes serialize(Object object) throws IOException {
        byte[] byArray = serializationMapper.writer().writeValueAsBytes(object);
        return new Bytes(byArray, byArray.length);
    }

    @Override
    public void serialize(Writer writer, Object object) throws IOException {
        serializationMapper.writer().writeValue(writer, object);
    }

    @Override
    public <T> T deserialize(Class<T> clazz, byte[] byArray, int n) throws IOException {
        return (T)this.deserializationMapper.readValue(byArray, 0, n, clazz);
    }

    @Override
    public <T> List<T> deserializeList(Class<T> clazz, byte[] byArray, int n) throws IOException {
        CollectionType collectionType = typeFactory.constructCollectionType(ArrayList.class, clazz);
        return (List)this.deserializationMapper.readValue(byArray, 0, n, (JavaType)collectionType);
    }

    private static class SnapshotDelegate<T extends AggregateRoot> {
        public final DateTime At;
        public final String Action;
        public final T Value;

        private SnapshotDelegate() {
            this(null, null, null);
        }

        public SnapshotDelegate(DateTime dateTime, String string, T t) {
            this.At = dateTime;
            this.Action = string;
            this.Value = t;
        }
    }

    private static class HistoryDelegate<T extends AggregateRoot> {
        public final List<SnapshotDelegate<T>> Snapshots = null;

        private HistoryDelegate() {
        }
    }

    static class AndroidConverters {
        AndroidConverters() {
        }

        private static void initAndroidSerializers(SimpleModule simpleModule) {
            simpleModule.addSerializer(Point.class, (JsonSerializer)new JsonSerializer<Point>(){

                public void serialize(Point point, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", point.x);
                    jsonGenerator.writeNumberField("Y", point.y);
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(PointF.class, (JsonSerializer)new JsonSerializer<PointF>(){

                public void serialize(PointF pointF, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", pointF.x);
                    jsonGenerator.writeNumberField("Y", pointF.y);
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(RectF.class, (JsonSerializer)new JsonSerializer<RectF>(){

                public void serialize(RectF rectF, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", rectF.right);
                    jsonGenerator.writeNumberField("Y", rectF.top);
                    jsonGenerator.writeNumberField("Width", rectF.width());
                    jsonGenerator.writeNumberField("Height", rectF.height());
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(Bitmap.class, (JsonSerializer)new JsonSerializer<Bitmap>(){

                public void serialize(Bitmap bitmap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                    jsonGenerator.writeBinary(byteArrayOutputStream.toByteArray());
                }
            });
        }

        private static void initAndroidDeserializers(SimpleModule simpleModule) {
            simpleModule.addDeserializer(Point.class, (JsonDeserializer)new JsonDeserializer<Point>(){

                public Point deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    return new Point(jsonNode.get("X").asInt(), jsonNode.get("Y").asInt());
                }
            });
            simpleModule.addDeserializer(PointF.class, (JsonDeserializer)new JsonDeserializer<PointF>(){

                public PointF deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    return new PointF(jsonNode.get("X").floatValue(), jsonNode.get("Y").floatValue());
                }
            });
            simpleModule.addDeserializer(RectF.class, (JsonDeserializer)new JsonDeserializer<RectF>(){

                public RectF deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    float f = jsonNode.get("X").floatValue();
                    float f2 = jsonNode.get("Y").floatValue();
                    float f3 = jsonNode.get("Width").floatValue();
                    float f4 = jsonNode.get("Height").floatValue();
                    return new RectF(f2, f, f2 + f3, f - f4);
                }
            });
            simpleModule.addDeserializer(Bitmap.class, (JsonDeserializer)new JsonDeserializer<Bitmap>(){

                public Bitmap deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jsonParser.getBinaryValue());
                    return BitmapFactory.decodeStream((InputStream)byteArrayInputStream);
                }
            });
        }
    }

    static class JavaConverters {
        JavaConverters() {
        }

        private static void initJavaSerializers(SimpleModule simpleModule) {
            simpleModule.addSerializer(java.awt.Point.class, (JsonSerializer)new JsonSerializer<java.awt.Point>(){

                public void serialize(java.awt.Point point, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", point.x);
                    jsonGenerator.writeNumberField("Y", point.y);
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(Point2D.class, (JsonSerializer)new JsonSerializer<Point2D>(){

                public void serialize(Point2D point2D, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", point2D.getX());
                    jsonGenerator.writeNumberField("Y", point2D.getY());
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(Rectangle2D.class, (JsonSerializer)new JsonSerializer<Rectangle2D>(){

                public void serialize(Rectangle2D rectangle2D, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", rectangle2D.getX());
                    jsonGenerator.writeNumberField("Y", rectangle2D.getY());
                    jsonGenerator.writeNumberField("Width", rectangle2D.getWidth());
                    jsonGenerator.writeNumberField("Height", rectangle2D.getHeight());
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(BufferedImage.class, (JsonSerializer)new JsonSerializer<BufferedImage>(){

                public void serialize(BufferedImage bufferedImage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                    jsonGenerator.writeBinary(byteArrayOutputStream.toByteArray());
                }
            });
        }

        private static void initJavaDeserializers(SimpleModule simpleModule) {
            simpleModule.addDeserializer(java.awt.Point.class, (JsonDeserializer)new JsonDeserializer<java.awt.Point>(){

                public java.awt.Point deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode;
                    if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                        String[] stringArray = jsonParser.getValueAsString().split(",");
                        if (stringArray.length == 2) {
                            return new java.awt.Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                        }
                        throw new IOException("Unable to parse \"number,number\" format for point");
                    }
                    JsonNode jsonNode2 = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    JsonNode jsonNode3 = jsonNode2.get("X");
                    if (jsonNode3 == null) {
                        jsonNode3 = jsonNode2.get("x");
                    }
                    if ((jsonNode = jsonNode2.get("Y")) == null) {
                        jsonNode = jsonNode2.get("y");
                    }
                    return new java.awt.Point(jsonNode3 != null ? jsonNode3.asInt() : 0, jsonNode != null ? jsonNode.asInt() : 0);
                }
            });
            simpleModule.addDeserializer(Point2D.class, (JsonDeserializer)new JsonDeserializer<Point2D>(){

                public Point2D deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode;
                    if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                        String[] stringArray = jsonParser.getValueAsString().split(",");
                        if (stringArray.length == 2) {
                            return new Point2D.Double(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                        }
                        throw new IOException("Unable to parse \"number,number\" format for point");
                    }
                    JsonNode jsonNode2 = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    JsonNode jsonNode3 = jsonNode2.get("X");
                    if (jsonNode3 == null) {
                        jsonNode3 = jsonNode2.get("x");
                    }
                    if ((jsonNode = jsonNode2.get("Y")) == null) {
                        jsonNode = jsonNode2.get("y");
                    }
                    return new Point2D.Double(jsonNode3 != null ? jsonNode3.asDouble() : 0.0, jsonNode != null ? jsonNode.asDouble() : 0.0);
                }
            });
            simpleModule.addDeserializer(Rectangle2D.class, (JsonDeserializer)new JsonDeserializer<Rectangle2D>(){

                public Rectangle2D deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode;
                    JsonNode jsonNode2;
                    JsonNode jsonNode3;
                    if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                        String[] stringArray = jsonParser.getValueAsString().split(",");
                        if (stringArray.length == 4) {
                            return new Rectangle2D.Double(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]));
                        }
                        throw new IOException("Unable to parse \"number,number,number,number\" format for rectangle");
                    }
                    JsonNode jsonNode4 = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    JsonNode jsonNode5 = jsonNode4.get("X");
                    if (jsonNode5 == null) {
                        jsonNode5 = jsonNode4.get("x");
                    }
                    if ((jsonNode3 = jsonNode4.get("Y")) == null) {
                        jsonNode3 = jsonNode4.get("y");
                    }
                    if ((jsonNode2 = jsonNode4.get("Width")) == null) {
                        jsonNode2 = jsonNode4.get("width");
                    }
                    if ((jsonNode = jsonNode4.get("Height")) == null) {
                        jsonNode = jsonNode4.get("height");
                    }
                    return new Rectangle2D.Double(jsonNode5 != null ? jsonNode5.asDouble() : 0.0, jsonNode3 != null ? jsonNode3.asDouble() : 0.0, jsonNode2 != null ? jsonNode2.asDouble() : 0.0, jsonNode != null ? jsonNode.asDouble() : 0.0);
                }
            });
            simpleModule.addDeserializer(BufferedImage.class, (JsonDeserializer)new JsonDeserializer<BufferedImage>(){

                public BufferedImage deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jsonParser.getBinaryValue());
                    return ImageIO.read(byteArrayInputStream);
                }
            });
        }
    }
}

