/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.ClientRepository;
import com.dslplatform.client.StandardProxy;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.PersistableRepository;
import com.dslplatform.patterns.ServiceLocator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class ClientPersistableRepository<T extends AggregateRoot>
extends ClientRepository<T>
implements PersistableRepository<T> {
    protected final StandardProxy standardProxy;
    private final ExecutorService executorService;

    public ClientPersistableRepository(Class<T> clazz, ServiceLocator serviceLocator) {
        super(clazz, serviceLocator);
        this.standardProxy = serviceLocator.resolve(StandardProxy.class);
        this.executorService = serviceLocator.resolve(ExecutorService.class);
    }

    @Override
    public Future<List<String>> persist(Iterable<T> iterable, Iterable<Map.Entry<T, T>> iterable2, Iterable<T> iterable3) {
        return this.standardProxy.persist(iterable, iterable2, iterable3);
    }

    @Override
    public Future<List<String>> persist(T[] TArray, Map.Entry<T, T>[] entryArray, T[] TArray2) {
        return this.persist(Arrays.asList(TArray), Arrays.asList(entryArray), Arrays.asList(TArray2));
    }

    @Override
    public Future<List<String>> insert(T[] TArray) {
        return this.insert((T)Arrays.asList(TArray));
    }

    @Override
    public Future<List<String>> insert(Iterable<T> iterable) {
        return this.standardProxy.persist(iterable, null, null);
    }

    @Override
    public Future<String> insert(T t) {
        final Future<T> future = this.crudProxy.create(t);
        return this.executorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((AggregateRoot)future.get()).getURI();
            }
        });
    }

    @Override
    public Future<List<String>> update(Iterable<T> iterable) {
        ArrayList arrayList = new ArrayList();
        for (AggregateRoot aggregateRoot : iterable) {
            arrayList.add(new AbstractMap.SimpleEntry<Object, AggregateRoot>(null, aggregateRoot));
        }
        return this.standardProxy.persist(null, arrayList, null);
    }

    @Override
    public Future<List<String>> update(T[] TArray) {
        return this.update((T)Arrays.asList(TArray));
    }

    @Override
    public Future<T> update(T t) {
        return this.crudProxy.update(t);
    }

    @Override
    public Future<?> delete(Iterable<T> iterable) {
        return this.standardProxy.persist(null, null, iterable);
    }

    @Override
    public final Future<?> delete(T[] TArray) {
        return this.delete((T)Arrays.asList(TArray));
    }

    @Override
    public Future<?> delete(T t) {
        return this.crudProxy.delete(this.manifest, t.getURI());
    }
}

