/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.AmazonS3Repository;
import com.dslplatform.client.ApplicationProxy;
import com.dslplatform.client.ClientDomainEventStore;
import com.dslplatform.client.CrudProxy;
import com.dslplatform.client.DomainProxy;
import com.dslplatform.client.DslJsonSerialization;
import com.dslplatform.client.HttpApplicationProxy;
import com.dslplatform.client.HttpClient;
import com.dslplatform.client.HttpCrudProxy;
import com.dslplatform.client.HttpDomainProxy;
import com.dslplatform.client.HttpHeaderProvider;
import com.dslplatform.client.HttpReportingProxy;
import com.dslplatform.client.HttpStandardProxy;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.MapServiceLocator;
import com.dslplatform.client.ReportingProxy;
import com.dslplatform.client.SettingsHeaderProvider;
import com.dslplatform.client.StandardProxy;
import com.dslplatform.patterns.DomainEventStore;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.storage.S3Repository;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static ServiceLocator staticLocator;
    private static final Properties versionInfo;

    public static ServiceLocator getLocator() {
        if (staticLocator == null) {
            throw new RuntimeException("Bootstrap has not been initialized, call Bootstrap.init");
        }
        return staticLocator;
    }

    public static ServiceLocator init(Properties properties, Map<Class<?>, Object> map) throws IOException {
        return Bootstrap.init(properties, new MapServiceLocator(map));
    }

    public static ServiceLocator init(Properties properties) throws IOException {
        return Bootstrap.init(properties, new MapServiceLocator());
    }

    public static ServiceLocator init(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Provided input stream was null.");
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        return Bootstrap.init(properties, new MapServiceLocator());
    }

    private static ServiceLocator init(final Properties properties, final MapServiceLocator mapServiceLocator) throws IOException {
        if (properties == null) {
            throw new IOException("Provided properties was null.");
        }
        mapServiceLocator.register(Properties.class, properties);
        final JsonSerialization jsonSerialization = mapServiceLocator.resolveOrRegister(JsonSerialization.class, new MapServiceLocator.LazyInstance<JsonSerialization>(){

            @Override
            public JsonSerialization create() {
                return new DslJsonSerialization(mapServiceLocator);
            }
        });
        final Logger logger = mapServiceLocator.resolveOrRegister(Logger.class, new MapServiceLocator.LazyInstance<Logger>(){

            @Override
            public Logger create() {
                return LoggerFactory.getLogger((String)"dsl-client-http");
            }
        });
        final ExecutorService executorService = mapServiceLocator.resolveOrRegister(ExecutorService.class, new MapServiceLocator.LazyInstance<ExecutorService>(){

            @Override
            public ExecutorService create() {
                return Executors.newCachedThreadPool();
            }
        });
        final HttpHeaderProvider httpHeaderProvider = mapServiceLocator.resolveOrRegister(HttpHeaderProvider.class, new MapServiceLocator.LazyInstance<HttpHeaderProvider>(){

            @Override
            public HttpHeaderProvider create() {
                return new SettingsHeaderProvider(properties);
            }
        });
        final HttpClient httpClient = mapServiceLocator.resolveOrRegister(HttpClient.class, new MapServiceLocator.LazyInstance<HttpClient>(){

            @Override
            public HttpClient create() {
                return new HttpClient(properties, jsonSerialization, logger, httpHeaderProvider, executorService);
            }
        });
        final DomainProxy domainProxy = mapServiceLocator.resolveOrRegister(DomainProxy.class, new MapServiceLocator.LazyInstance<DomainProxy>(){

            @Override
            public DomainProxy create() {
                return new HttpDomainProxy(httpClient);
            }
        });
        mapServiceLocator.resolveOrRegister(ApplicationProxy.class, new MapServiceLocator.LazyInstance<ApplicationProxy>(){

            @Override
            public ApplicationProxy create() {
                return new HttpApplicationProxy(httpClient);
            }
        });
        mapServiceLocator.resolveOrRegister(CrudProxy.class, new MapServiceLocator.LazyInstance<CrudProxy>(){

            @Override
            public CrudProxy create() {
                return new HttpCrudProxy(httpClient);
            }
        });
        mapServiceLocator.resolveOrRegister(StandardProxy.class, new MapServiceLocator.LazyInstance<StandardProxy>(){

            @Override
            public StandardProxy create() {
                return new HttpStandardProxy(httpClient, jsonSerialization, executorService);
            }
        });
        mapServiceLocator.resolveOrRegister(ReportingProxy.class, new MapServiceLocator.LazyInstance<ReportingProxy>(){

            @Override
            public ReportingProxy create() {
                return new HttpReportingProxy(httpClient, executorService, jsonSerialization);
            }
        });
        mapServiceLocator.resolveOrRegister(DomainEventStore.class, new MapServiceLocator.LazyInstance<DomainEventStore>(){

            @Override
            public DomainEventStore create() {
                return new ClientDomainEventStore(domainProxy);
            }
        });
        if (properties.getProperty("s3-user") != null) {
            Bootstrap.registerS3(mapServiceLocator, properties, executorService);
        }
        staticLocator = mapServiceLocator;
        return staticLocator;
    }

    private static void registerS3(MapServiceLocator mapServiceLocator, final Properties properties, final ExecutorService executorService) {
        mapServiceLocator.resolveOrRegister(S3Repository.class, new MapServiceLocator.LazyInstance<S3Repository>(){

            @Override
            public S3Repository create() {
                return new AmazonS3Repository(properties, executorService);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceLocator init(String string) throws IOException {
        if (string == null) {
            throw new IOException("Provided path to properties file was null.");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            ServiceLocator serviceLocator = Bootstrap.init(fileInputStream);
            return serviceLocator;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    private static String getVersionInfo(String string) {
        if (versionInfo.isEmpty()) {
            try {
                versionInfo.load(Bootstrap.class.getResourceAsStream("dsl-client.properties"));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return versionInfo.getProperty(string);
    }

    public static String getVersion() {
        return Bootstrap.getVersionInfo("version");
    }

    public static String getReleaseDate() {
        return Bootstrap.getVersionInfo("date");
    }

    public static void main(String[] stringArray) {
        String string = String.format("dsl-client-java-%s.jar (released on: %s)", Bootstrap.getVersion(), Bootstrap.getReleaseDate());
        System.out.println();
        System.out.println(string);
        System.out.println(string.replaceAll(".", "-"));
        System.out.println();
        System.out.println("This is the Java version of the DSL Platform client library");
        System.out.println("and is not intended to run as a standalone application.");
        System.out.println();
        System.out.println("For more information, visit https://dsl-platform.com/");
        System.out.println();
    }

    static {
        versionInfo = new Properties();
    }
}

