/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.dslplatform.storage.S3Repository;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class AmazonS3Repository
implements S3Repository {
    private final String s3AccessKey;
    private final String s3SecretKey;
    private final String s3Region;
    private final ExecutorService executorService;
    private AmazonS3Client s3Client;

    private AmazonS3Client getS3Client() throws IOException {
        if (this.s3Client == null) {
            if (this.s3AccessKey == null || this.s3AccessKey.isEmpty()) {
                throw new IOException("S3 configuration is missing. Please add s3-user");
            }
            if (this.s3SecretKey == null || this.s3SecretKey.isEmpty()) {
                throw new IOException("S3 configuration is missing. Please add s3-secret");
            }
            this.s3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(this.s3AccessKey, this.s3SecretKey));
            if (this.s3Region != null) {
                this.s3Client.setRegion(Region.getRegion((Regions)Regions.fromName((String)this.s3Region)));
            }
        }
        return this.s3Client;
    }

    public AmazonS3Repository(Properties properties, ExecutorService executorService) {
        this.s3AccessKey = properties.getProperty("s3-user");
        this.s3SecretKey = properties.getProperty("s3-secret");
        this.s3Region = properties.getProperty("s3-region");
        this.executorService = executorService;
    }

    private void checkBucket(String string) throws IOException {
        if (string == null || string.isEmpty()) {
            throw new IOException("Bucket not specified. If you wish to use default bucket name, add it as s3-bucket into properties.");
        }
    }

    @Override
    public Future<InputStream> get(final String string, final String string2) {
        return this.executorService.submit(new Callable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                S3Object s3Object = AmazonS3Repository.this.getS3Client().getObject(new GetObjectRequest(string, string2));
                return s3Object.getObjectContent();
            }
        });
    }

    @Override
    public Future<?> upload(final String string, final String string2, final InputStream inputStream, final long l, final Map<String, String> map) {
        return this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                AmazonS3Repository.this.checkBucket(string);
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setContentLength(l);
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        objectMetadata.addUserMetadata((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                AmazonS3Repository.this.getS3Client().putObject(new PutObjectRequest(string, string2, inputStream, objectMetadata));
                return null;
            }
        });
    }

    @Override
    public Future<?> delete(final String string, final String string2) {
        return this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                AmazonS3Repository.this.getS3Client().deleteObject(new DeleteObjectRequest(string, string2));
                return null;
            }
        });
    }
}

