/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.plugin.editor;

import com.dslplatform.grammar.NGSLexer;
import com.dslplatform.grammar.NGSParser;
import com.dslplatform.grammar.SyntaxConcept;
import com.dslplatform.grammar.SyntaxType;
import com.dslplatform.plugin.Logger;
import com.dslplatform.plugin.editor.ClassificationFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class TokenScanner
implements ITokenScanner {
    private final ArrayList<SyntaxConcept> concepts = new ArrayList();
    private final List<Integer> lineOffsets = new ArrayList<Integer>();
    private int lastScannedIndex;

    public void setRange(IDocument document, int offset, int length) {
        try {
            String dsl = document.get(0, document.getLength());
            this.parse("dsl", dsl);
            try {
                this.calculateLineOffsets(dsl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public IToken nextToken() {
        while (true) {
            ++this.lastScannedIndex;
            if (this.lastScannedIndex >= this.concepts.size()) {
                return Token.EOF;
            }
            SyntaxConcept concept = this.getLastConcept();
            TextAttribute attr = ClassificationFormat.getTextAttribute(concept);
            if (attr != null) {
                Logger.debug("token: '" + concept.Type + "' @" + concept.Line + "," + concept.Column + "; value: " + concept.Value);
                return new Token((Object)attr);
            }
            Logger.debug("ignored: '" + concept.Type + "' @" + concept.Line + "," + concept.Column + "; value: " + concept.Value);
        }
    }

    public int getTokenOffset() {
        SyntaxConcept concept = this.getLastConcept();
        return this.getOffset(concept.Line, concept.Column);
    }

    public int getTokenLength() {
        return this.getLastConcept().Value.length();
    }

    private void parse(String script, String content) {
        this.reset();
        ANTLRStringStream stream = new ANTLRStringStream(content);
        NGSLexer lexer = new NGSLexer((CharStream)stream);
        NGSParser parser = new NGSParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        try {
            parser.ProcessDsl(script);
        }
        catch (RecognitionException ex) {
            Logger.debug("PARSE EXCEPTION: @line " + ex.line + ex.getMessage());
        }
        List<SyntaxConcept> parsed = parser.GetSyntax();
        parsed = this.orderConcepts(parsed);
        parsed = this.delimitConcepts(parsed);
        this.concepts.addAll(parsed);
    }

    private List<SyntaxConcept> delimitConcepts(List<SyntaxConcept> concepts) {
        ArrayList<SyntaxConcept> delimited = new ArrayList<SyntaxConcept>();
        int i = 0;
        while (i < concepts.size()) {
            SyntaxConcept current = concepts.get(i);
            delimited.add(current);
            if (i < concepts.size() - 1 && ClassificationFormat.hasTextAttribute(current.Type)) {
                delimited.add(new SyntaxConcept(SyntaxType.Delimiter, " ", "dsl", current.Line, current.Column + current.Value.length()));
            }
            ++i;
        }
        return delimited;
    }

    private List<SyntaxConcept> orderConcepts(List<SyntaxConcept> concepts) {
        ArrayList<SyntaxConcept> ordered = new ArrayList<SyntaxConcept>();
        int i = 0;
        while (i < concepts.size()) {
            SyntaxConcept current = concepts.get(i);
            int pr = i - 1;
            while (pr > 0) {
                SyntaxConcept previous = concepts.get(pr);
                if (previous.Line < current.Line || previous.Line == current.Line && previous.Column < current.Column) break;
                --pr;
            }
            ordered.add(pr + 1, current);
            ++i;
        }
        return ordered;
    }

    private int getOffset(int line, int column) {
        return this.lineOffsets.get(line - 1) + column;
    }

    private void calculateLineOffsets(String content) throws IOException {
        int singleChar;
        int offset = 0;
        BufferedReader reader = new BufferedReader(new StringReader(content));
        this.lineOffsets.clear();
        this.lineOffsets.add(0);
        while ((singleChar = reader.read()) != -1) {
            char c = (char)singleChar;
            ++offset;
            if (c == '\u0000') break;
            if (c == '\n') {
                this.lineOffsets.add(offset);
            }
            if (c != '\r') continue;
            c = (char)reader.read();
            if (c == '\n') {
                this.lineOffsets.add(++offset);
                continue;
            }
            this.lineOffsets.add(offset);
            ++offset;
        }
    }

    private void reset() {
        this.lastScannedIndex = -1;
        this.concepts.clear();
    }

    private SyntaxConcept getLastConcept() {
        return this.concepts.get(this.lastScannedIndex);
    }
}

