/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.plugin.editor;

import com.dslplatform.plugin.editor.ITextPresentationUpdater;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DelayedDamagerRepairer
extends DefaultDamagerRepairer {
    private final ITextPresentationUpdater updater;
    private final long delay;
    private final ParseJob parseJob;

    public DelayedDamagerRepairer(ITokenScanner scanner, ITextPresentationUpdater updater, long delay) {
        super(scanner);
        this.updater = updater;
        this.delay = delay;
        this.parseJob = new ParseJob("DSL parsing", this, updater);
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        this.parseJob.setPresentation(presentation);
        this.parseJob.setRegion(region);
        this.parseJob.cancel();
        this.parseJob.schedule(this.delay);
    }

    public void updatePresentation(TextPresentation presentation, ITypedRegion region) {
        super.createPresentation(presentation, region);
    }

    private class ParseJob
    extends Job {
        private TextPresentation presentation;
        private ITypedRegion region;
        private final ITextPresentationUpdater updater;
        private final DelayedDamagerRepairer dr;

        public void setPresentation(TextPresentation presentation) {
            this.presentation = presentation;
        }

        public void setRegion(ITypedRegion region) {
            this.region = region;
        }

        public ParseJob(String name, DelayedDamagerRepairer dr, ITextPresentationUpdater updater) {
            super(name);
            this.updater = updater;
            this.dr = dr;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.dr.updatePresentation(this.presentation, this.region);
            final Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        ParseJob.this.updater.updateTextPresentation(ParseJob.this.presentation);
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

